package com.digiwin.athena.atmc.common.domain.email;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.atmc.http.domain.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Accessors(chain = true)
@TableName(autoResultMap = true, value = "activity_email_relation")
public class ActivityEmailRelation extends BaseEntity<ActivityEmailRelation> {
    @TableId()
    private Long id;

    private String tenantId;

    /**
     * 项目id
     */
    private String taskId;

    /**
     * 任务id
     */
    private String activityId;

    /**
     * 关联的邮件模板id
     * activity_email_management---email_id
     */
    private Long emailId;

}
