package com.digiwin.athena.atmc.common.domain.project;

import com.digiwin.athena.appcore.domain.LanguageMark;
import com.digiwin.athena.atmc.common.domain.backlog.CardConfigDTO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ProjectCardDTO {

    /**
     * 项目主键,task.id
     */
    private long id;

    /**
     * 项目名称，task.name
     */
    @LanguageMark
    private String name;

    /**
     * 格式："{"zh_CN":"xxx", "zh_TW": "xxxxx", "en_US": "xxxxxx"}"
     */
    private String withName;

    /**
     * 项目时距开始时间，task.start_time
     */
    private LocalDateTime startTime;

    /**
     * 项目时距结束时间，task.end_time
     */
    private LocalDateTime endTime;

    /**
     * 重要，特别关注
     */
    private boolean importance;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 项目包含的任务数量
     */
    private long taskCount;

    /**
     * 紧急度
     */
    private long emergency;

    /**
     * 紧急子项目的数量
     */
    private long emergencyProjectCount;

    /**
     * 子项目数量
     */
    private long subProjectCount;

    /**
     * 已完成的子项目数量
     */
    private long subProjectFinishedCount;

    /**
     * 是否是变更项目
     */
    private boolean changed;

    /**
     * 变更活动所属主活动Id
     */
    private Long changedMainTaskId;

    /**
     * 是否是自己的项目
     */
    private Boolean isOwner = false;

    /**
     * 项目所属人ID
     */
    private String ownerUserId;

    /**
     * 项目所属人名称
     */
    private String ownerUserName;

    /**
     * 代理人id  被谁代理
     */
    private String ownerAgentUserId;

    /**
     * 代理人名称  被谁代理
     */
    private String ownerAgentUserName;

    /**
     * 已读次数
     */
    private long readCount;

    /**
     * ThemeMap中定义的项目ID
     */
    private String tmTaskId;

    /**
     * 项目卡是否包含异常任务
     */
    private boolean exception;

    /**
     * 项目卡是否包含逾期
     */
    private boolean overdue;

    /**
     * 项目最后一次修改时间
     */
    private LocalDateTime modifyDate;

    /**
     * 项目已经发生了变化
     */
    private boolean hasDataChanged;

    /**
     * 包含的任务列表
     */
    private List<Map<String, Object>> tasks;

    /**
     * 项目名称，task.project_name
     */
    @LanguageMark
    private String projectName;

    /**
     * 格式："{"zh_CN":"xxx", "zh_TW": "xxxxx", "en_US": "xxxxxx"}"
     */
    private String projectDefWithName;

    /**
     * 项目的pattern，
     */
    private String tmPattern;

    /**
     * 關鍵業務數據
     */
    private String majorData;

    /**
     * 最近新增加的来源单号
     */
    private String lastNewSourceIds;

    /**
     * 引擎类型
     */
    private String engineType;

    /**
     * 可否支持转派
     */
    private Boolean reAssignAble;
    /**
     * 是否为钉选
     */
    private Boolean pinning;
    /**
     * 当责者
     */
    private String personInCharge;
    /**
     * 当责者名称
     */
    private String personInChargeName;

    /**
     * 项目来源：PTM表示来源于PTM，其他表示ATMC
     * <p>参考：BpmConstant.DATA_FROM_PTM</p>
     */
    private String dataFrom;
    /**
     * 摘要
     */
    private String summary;
    /**
     * 历史资讯
     */
    private String historyMessage;
    /**
     * 查询数据
     */
    private String searchMessage;

    /**
     * 项目卡是否中断
     */
    private boolean interrupt;

    /**
     * 打开项目卡的方式，为null表示平台打开，其他表示客制打开
     */
    private Map action;

    /**
     * 是否转派项目
     */
    private Boolean reassign;

    /**
     * 是否交接项目
     */
    private Boolean handover;

    /**
     * 是否隐藏卡片
     */
    private Boolean hiddenForUser;

    /**
     * 提交唯一标识
     */
    private Integer submitId;

    /**
     * 是否有应用授权
     */
    private Boolean hasAppPermission;

    /**
     * 应用code
     */
    private String appCode;

    /**
     * 应用名称
     */
    private String appName;

    private String tenantId;

    /**
     * 业务数据
     */
    private Map<String, List<String>> businessMessage;

    /**
     * 分组等配置
     */
    private List<CardConfigDTO> cardConfig;
    /**
     * 卡面业务数据的来源方式
     * REAL_TIME(默认)/NON_REAL_TIME
     */
    private String businessMessageSourceMethod;

    /**
     *来源处理者id
     */
    private String oldPerformerId;
    /**
     *来源处理者姓名
     */
    private String oldPerformerName;

}
