package com.digiwin.athena.atmc.common.domain.ptm.model;

import com.baomidou.mybatisplus.core.enums.IEnum;

import java.util.Objects;

public enum PtmMqOperation implements IEnum<String> {

    /**
     * 无特殊含义
     */
    NONE("NONE"),

    /**
     * 创建
     */
    ADD("ADD"),

    /**
     * 钉选
     */
    PINNING("PINNING"),

    /**
     * 更新/变化
     */
    CHANGE("CHANGE"),

    /**
     * 完成
     */
    CLOSE("CLOSE"),

    /**
     * 逾时
     */
    OVERDUE("OVERDUE"),

    /**
     * 催办
     */
    REMINDER("REMINDER");

    private String _value;

    PtmMqOperation(String v){
        this._value = v;
    }

    @Override
    public String getValue() {
        return _value;
    }

    public String getMqttCategory(){
        if(Objects.equals(this.getValue(), PtmMqOperation.CHANGE.getValue())){
            return "EDIT";
        }
        return this.getValue();
    }
}
