package com.digiwin.athena.atmc.common.domain.ptm.model;

import com.baomidou.mybatisplus.core.enums.IEnum;

/**
 * PTM 消息对象类别枚举
 */
public enum PtmMqType  implements IEnum<String> {

    /**
     * 项目卡(主项目)
     */
    projectCard("projectCard"),

    /**
     * 项目(子项目)
     */
    project("project"),

    /**
     * 任务卡
     */
    task("task"),

    /**
     * 工作项(包含活动+事项)的操作
     */
    workItem("workItem"),

    /**
     * 待办
     */
    backlog("backlog"),

    /**
     * 任务数据一致性
     */
    dataConsistency("dataConsistency"),

    /**
     * 知会
     */
    signInform("signInform");

    private String _value;

    PtmMqType(String v){
        this._value = v;
    }

    @Override
    public String getValue() {
        return _value;
    }

}
