package com.digiwin.athena.atmc.common.domain.ptm.model;


import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;

/**
 * PTM 项目卡(主项目) 数据
 * @author zhujg
 * @date 2022-01-21
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class PtmProjectCardDTO {

    private Long id;
    private String projectCode;
    private String projectName;
    private LocalDateTime startTime;
    private LocalDateTime endTime;
    private String personInCharge;
    private String personInChargeName;
    private Integer state;
    private Boolean completedReport;
    private String engine;
    private String targetId;
    private String targetName;

    /**
     * 增加PTM项目卡的自定义名称
     */
    private String name;

    /**
     * 项目卡是否隐藏
     */
    private Boolean hidden;
}
