package com.digiwin.athena.atmc.common.domain.route;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.atmc.http.domain.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 路线表
 * @author：SYQ
 * @date：2021/7/28
 */

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Accessors(chain = true)
@TableName(autoResultMap = true)
public class Route extends BaseEntity<Route> implements Serializable {
    @TableId()
    private Long id;

    /**
     * 路线名称
     */
    private String routeName;
    /**
     * 路径
     */
    private String pass;
    /**
     * 主项目id
     */
    private Long mainTaskId;
    /**
     * 子项目id
     */
    private Long taskId;
    /**
     * 顺序
     */
    private Integer routeOrder;
    /**
     * 是否被选中 0-未选中，1-选中
     */
    private Integer selected;
    /**
     * 当前路线开始分支的关卡的下标，多个以逗号分隔
     */
    private Integer branchIndex;
}
