package com.digiwin.athena.atmc.common.domain.route;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.atmc.http.domain.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 任务实例路线表
 * @author：SYQ
 * @date：2021/7/28
 */

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Accessors(chain = true)
@TableName(autoResultMap = true)
public class RouteDetail extends BaseEntity<RouteDetail> implements Serializable {
    @TableId()
    private Long id;

    /**
     * 任务id
     */
    private Long bpmActivityId;
    /**
     * 任务实例id
     */
    private String taskUid;
    /**
     * 上一个任务实例id
     */
    private String preTaskUid;
    /**
     * 任务code
     */
    private String tmActivityId;
    /**
     * 关卡名称
     */
    private String tmActivityName;
    /**
     * 任务输入数据状态描述
     */
    private String inputDescribe;
    /**
     * 预测关卡
     */
    private String forecastActivity;
    /**
     * 路径
     */
    private String pass;
    /**
     * 所属路线id
     */
    private Long routeId;
    /**
     * 租户id
     */
    private String tenantId;
    /**
     * 项目id
     */
    private Long taskId;
}
