package com.digiwin.athena.atmc.common.domain.task;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class TaskListRespDTO {

    /**
     * 任务名称
     */
    private String taskName;

    /**
     * 应用系统名称
     */
//    private String systemName;

    /**
     * 驱动时间
     */
    private String startTime;

    /**
     * 最后异动时间
     */
    private String updateTime;

    /**
     * 停滞时间
     */
    private String stagnateTime;

    /**
     * 当责者姓名
     */
    private String chargePersonName;

    /**
     * 状态(紧急、重要、异常)
     */
    private String status;

    private  Integer mainTaskEmergencyCount;

    private Integer importanceCount;

    private  Integer exception;
    /**
     * 任务id
     */
    private String taskId;

    /**
     * 类型：1-未完成 2-已完成
     */
    private Integer type;

    /**
     * 是否紧急。0-一般，1-紧急
     */
    @JsonIgnore
    private Integer emergency;

    /**
     * 重要性,0-一般,1-重要
     */
    @JsonIgnore
    private Integer importance;

    /**
     * 任务结束时间
     */
    @JsonIgnore
    private String taskEndTime;

    /**
     * 流程关闭时间
     */
    @JsonIgnore
    private String processCloseTime;

}