package com.digiwin.athena.atmc.common.domain.task;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.Set;

@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
@EqualsAndHashCode(exclude = {"sourceIds"})
public class TaskSourceDTO {

    /**
     * 运营单元编号
     */
    private String eocCode;

    /**
     * 运营单元名称
     */
    private String eocName;

    /**
     * 运营单元类别
     */
    private Integer eocType;

    /**
     * 工单信息
     */
    private Set<String> sourceIds;

    public TaskSourceDTO(String eocName, Integer eocType) {
        this.eocName = eocName;
        this.eocType = eocType;
    }
}
