package com.digiwin.athena.atmc.common.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.baomidou.mybatisplus.core.enums.IEnum;
import com.fasterxml.jackson.annotation.JsonValue;

public enum ActivityWorkitemSubState implements IEnum<Integer> {
    /**
     * 0	未開始
     * 0	進行中
     * 0	暫停
     * 10	正常完成
     * 20	終止項目而關閉
     * 30	其他處理者已處理完成
     * 50	往前加簽而關閉
     * 60	退回重簽而關閉
     * 80	由第三方強制終止項目而關閉
     * 90	項目被撤銷而關閉
     * 100	其他任務已處理完成而關閉
     * 110	因轉派而關閉
     * 120	因他人執行退回重簽而關閉
     * 130	因其他人執行往前加簽而關閉
     * 140	往後加簽而關閉
     * 150	因退回重辦而關閉
     * 160	因其他人執行退回重辦而關閉
     * 190	取回重辦而關閉
     * 200  取回重簽而关闭
     */

    /**
     * 未開始、進行中、暫停
     */
    NORMAL(0),

    /**
     * 正常完成
     */
    COMPLETED(10),

    /**
     * 終止項目而關閉
     */
    END_TERMINATION_TASK(20),

    /**
     * 其他處理者已處理完成
     */
    END_OTHER_USER_COMPLETED(30),

    /**
     * 往前加簽而關閉
     */
    END_FORWARD_COUNTERSIGN(50),

    /**
     * 退回重签而关闭
     */
    END_RETURN_RE_SIGN(60),


    /**
     * 由第三方強制終止項目而關閉
     */
    END_TERMINATION(80),

    /**
     * 項目被撤銷而關閉
     */
    END_TASK_UNDO(90),

    /**
     * 其他任務已處理完成而關閉
     */
    END_OTHER_ACTIVITY_CLOSED(100),

    /**
     * 因轉派而關閉
     */
    end_reassign(110),

    /**
     * 因他人執行退回重簽而關閉
     */
    end_other_RETURN_RE_SIGN(120),

    /**
     * 因其他人執行往前加簽而關閉
     */
    END_OTHER_FORWARD_COUNTERSIGN(130),

    /**
     * 往後加簽而關閉
     */
    END_BACKWARD_COUNTERSIGN(140),

    /**
     * 退回重办而关闭
     */
    END_RETURN_REDO(150),

    /**
     * 因其他人執行退回重辦而關閉
     */
    END_OTHER_RETURN_REDO(160),

    /**
     * 签核关卡跳过
     */
    AUTO_DISPATCH_PROCESS(260),

    /**
     * 交接
     */
    HANDOVER(290),

    /**
     * 取回重辦而關閉
     */
    END_RETRIEVE_REDO( 190),

    /**
     * 取回重簽而关闭
     */
    END_RETRIEVE_RESIGN(200);

    @EnumValue
    @JsonValue    //标记响应json值
    private int code;

    public int getCode(){
        return code;
    }

    ActivityWorkitemSubState(int code){
        this.code = code;
    }

    @Override
    public Integer getValue() {
        return code;
    }
}
