package com.digiwin.athena.atmc.common.enums;

import com.baomidou.mybatisplus.core.enums.IEnum;
import org.apache.commons.lang.StringUtils;

public enum SignCategory  implements IEnum<Integer> {

    /**
     * 1-signOr-或签
     */
    SIGNOR("signOr", 1),

    /**
     * 2-signAnd-会签
     */
    SIGNAND("signAnd", 2),

    /**
     * 3-single-单一签核
     */
    SINGLE("single", 3);

    private String name;
    private Integer value;

    SignCategory(String name,Integer value){
        this.name = name;
        this.value = value;
    }

    public String getName() { return name;}

    @Override
    public Integer getValue() {
        return value;
    }

    public static SignCategory parse(String signType){
        if(StringUtils.equalsIgnoreCase(signType, SIGNAND.getName())){
            return SIGNAND;
        }else if(StringUtils.equalsIgnoreCase(signType, SIGNOR.getName())){
            return SIGNOR;
        }else{
            return SINGLE;
        }

    }
}
