package com.digiwin.athena.atmc.common.enums;

import com.baomidou.mybatisplus.core.enums.IEnum;

/**
 * workitem 的 createType 枚举值
 */
public enum WorkitemCreateType implements IEnum<Integer> {

    /**
     * 0.正常产生
     */
    NORMAL(0),

    /**
     * 1.转派
     */
    REASSIGN(1),

    /**
     * 2.退回重签
     */
    REAPPROVAL(2),

    /**
     * 3.退回重办
     */
    REEXECUTE(3),

    /**
     * 4.加签
     */
    ADDTASK(4),

    /**
     * 5.外部新增
     */
    EXTERNAL_NEW(5),

    /**
     * 6.取回重簽
     */
    ROLLBACK_APPROVE(6),

    /**
     *  7.數據轉派
     */
    DATA_REASSIGN(7),

    /**
     * 8.取回重辦
     */
    ROLLBACK(8),

    /**
     * 9.撤回
     */
    RECALL(9),

    /**
     * 10.交接
     */
    HANDOVER(10);

    private Integer code;

    WorkitemCreateType(Integer code){
        this.code = code;
    }

    public int getCode(){
        return code;
    }

    @Override
    public Integer getValue() {
        return code;
    }

}
