package com.digiwin.athena.atmc.common.enums;

import com.baomidou.mybatisplus.core.enums.IEnum;

/**
 * BPM中的workItem状态
 */
public enum WorkitemState  implements IEnum<Integer>  {

    /*
0:未開始
1:進行中
2:已暫停
3:已完成
4:已撤銷
5:已中止
6:退回重辦
7:新增關卡(往前加簽)
8:取回重辦
9:已通知
10:已會辦
97:自動簽核(雲上未實作)
     */

    /**
     * 0.未开始
     */
    UNSTART(0),

    /**
     * 1.关卡正在执行（进行）中
     */
    EXECUTEING(1),

    /**
     * 2.关卡暂停
     */
    PAUSE(2),

    /**
     * 3.关卡顺利完成
     */
    COMPLETED(3),

    /**
     * 4.撤銷
     */
    UNDO(4),

    /**
     * 5.已中止
     */
    ABORT(5),

    /**
     * 6.退回重办
     */
    REEXCUTE(6);

    private Integer code;

    WorkitemState(Integer code){
        this.code = code;
    }

    public int getCode(){
        return code;
    }

    @Override
    public Integer getValue() {
        return code;
    }

}
