package com.digiwin.athena.atmc.common.mongodb;

import java.util.Map;

/**
 * mongoDB查询工具服务
 */
public interface MongoDbQueryService {

    /**
     * 生成 executeCommand 查询对象
     * @param collectionName collection名称
     * @param filterMap 查询条件
     * @return
     */
    Map getExecuteQueryCommand(String collectionName, Map filterMap);

    /**
     * 生成 executeCommand 查询对象
     * <br>参考：https://www.mongodb.com/docs/manual/reference/command/find/#mongodb-dbcommand-dbcmd.find
     *
     * @param collectionName collection名称
     * @param filterMap 查询条件
     * @param projectionMap 返回属性
     * @return
     */
    Map getExecuteQueryCommand(String collectionName, Map filterMap, Map projectionMap);

    /**
     * 将map的Key平铺，并加上指定的前缀。
     * <p>不处理含list的value</p>
     * @param prefix
     * @param oldMap 旧的map
     * @return 平铺后的map
     */
    Map tileMap(String prefix, Map oldMap);

}
