package com.digiwin.athena.atmc.common.service.backlog;

import cn.hutool.core.collection.CollectionUtil;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.TimeUtils;
import com.digiwin.athena.atmc.common.bk.service.BusinessKeyService;
import com.digiwin.athena.atmc.common.constant.ApiExecuteErrorConstant;
import com.digiwin.athena.atmc.infrastructure.mapper.biz.migration.BacklogMapper;
import com.digiwin.athena.atmc.common.dao.BpmActivityMapper;
import com.digiwin.athena.atmc.common.dao.BpmActivityStepMapper;
import com.digiwin.athena.atmc.common.dao.BpmActivityWorkitemMapper;
import com.digiwin.athena.atmc.infrastructure.mapper.biz.migration.PtmBacklogMapper;
import com.digiwin.athena.atmc.common.dao.route.RouteDetailMapper;
import com.digiwin.athena.atmc.common.domain.BpmActivity;
import com.digiwin.athena.atmc.common.domain.BpmActivityStep;
import com.digiwin.athena.atmc.infrastructure.pojo.po.migration.BpmActivityWorkitem;
import com.digiwin.athena.atmc.common.domain.BpmWorkitemAppendix;
import com.digiwin.athena.atmc.common.enums.ActivityWorkitemSubState;
import com.digiwin.athena.atmc.core.meta.enums.BpmEngineCategoryEnum;
import com.digiwin.athena.atmc.common.enums.WorkitemAppendixType;
import com.digiwin.athena.atmc.common.service.bpmworkitemappendix.BpmWorkitemAppendixService;
import com.digiwin.athena.atmc.common.service.ptm.CommonPtmTransformService;
import com.digiwin.athena.atmc.common.service.ptm.PtmBacklogTransformService;
import com.digiwin.athena.atmc.common.util.PatternCategoryUtil;
import com.digiwin.athena.atmc.http.constant.BpmConstant;
import com.digiwin.athena.atmc.http.constant.ErrorCodeEnum;
import com.digiwin.athena.atmc.core.meta.constants.GlobalConstant;
import com.digiwin.athena.atmc.infrastructure.pojo.po.migration.Backlog;
import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.ActivityDataBO;
import com.digiwin.athena.atmc.http.restful.bpm.BpmService;
import com.digiwin.athena.atmc.http.restful.bpm.TaskEngineService;
import com.digiwin.athena.atmc.http.restful.bpm.model.BpmTaskApprovePreviousActivityDTO;
import com.digiwin.athena.atmc.http.restful.bpm.model.BpmTaskPreApproveRequestDTO;
import com.digiwin.athena.atmc.http.restful.eoc.EocService;
import com.digiwin.athena.atmc.http.restful.eoc.model.EocTenantAllUserDTO;
import com.digiwin.athena.atmc.application.dto.response.eoc.ProxyUserResp;
import com.digiwin.athena.atmc.http.restful.ptm.PtmService;
import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.PtmWorkItemRecordBO;
import com.digiwin.athena.atmc.http.restful.thememap.ThemeMapService;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmActivityResponseDTO;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmPageName;
import com.digiwin.athena.atmc.core.meta.enums.km.TmTaskCategoryEnum;
import com.digiwin.athena.atmc.core.meta.enums.km.TmTaskPatternEnum;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class BpmBacklogActionCreateService extends BacklogActionCreateParentService {

    @Autowired
    private BpmActivityMapper bpmActivityMapper;

    @Autowired
    private BacklogMapper backlogMapper;

    @Autowired
    private ThemeMapService themeMapService;

    @Autowired
    private BpmActivityStepMapper bpmActivityStepMapper;

    @Autowired
    private BpmService bpmService;

    @Autowired
    private BpmActivityWorkitemMapper bpmActivityWorkitemMapper;

    @Autowired
    private RouteDetailMapper routeDetailMapper;

    @Autowired
    private PtmBacklogTransformService ptmBacklogTransformService;

    @Autowired
    private BpmWorkitemAppendixService bpmWorkitemAppendixService;

    @Autowired
    private PtmService ptmService;

    @Autowired
    private MessageUtils messageUtils;

    @Autowired
    private TaskEngineService taskEngineService;

    @Autowired
    private CommonPtmTransformService commonPtmTransformService;

    @Autowired
    private BusinessKeyService businessKeyService;

    @Autowired
    private PtmBacklogMapper ptmBacklogMapper;

    @Autowired
    private EocService eocService;

    public Map<String, Object> getEditActions(AuthoredUser authoredUser, long workitemId, Boolean isHistory) {
        return getEditActions(authoredUser, workitemId, isHistory, null);
    }

    /**
     * @param workitemId
     * @return
     */
    public Map<String, Object> getEditActions(AuthoredUser authoredUser, long workitemId, Boolean isHistory, PtmWorkItemRecordBO ptmWorkItemRecordBO) {

        ActivityDataBO backLogMap = null;
        //perf：基于目前大部分数据是任务引擎，优先查询ptm数据，减少一次数据库查询连接和耗时 start
        Boolean isPtm = true;
        List<ActivityDataBO> list = commonPtmTransformService.getActivityDataByBacklogId(workitemId, isHistory, ptmWorkItemRecordBO);
        if (CollectionUtils.isEmpty(list)) {
            list = backlogMapper.getActivityDatasByBacklogId(workitemId);
            isPtm = false;
        }
        //perf：基于目前大部分数据是任务引擎，优先查询ptm数据，减少一次数据库查询连接和耗时 end

        //如果是数据一致性的异常排除任务卡则查询其原任务卡的数据
        BpmActivityWorkitem abnormalWorkitem = null;
        if (!isPtm) {
            abnormalWorkitem = bpmActivityWorkitemMapper.selectById(workitemId);
            if (abnormalWorkitem != null && abnormalWorkitem.getType() == 89) {
                list = backlogMapper.getActivityDatasByBacklogId(abnormalWorkitem.getSourceWorkitemId());
            }
        }

        if (list.size() > 1) {
            if (!isPtm) {
                Optional<ActivityDataBO> mainWorkItem = list.stream().filter(item -> item.getGroupId() == null || item.getGroupId() == 0L).findFirst();
                if (mainWorkItem.isPresent()) {
                    backLogMap = mainWorkItem.get();
                }
                list = list.stream().filter(item -> item.getGroupId() != null && item.getGroupId() > 0L).collect(Collectors.toList());
            } else {
                backLogMap = list.get(0);
            }
        } else if (list.size() == 1) {
            backLogMap = list.get(0);
        }


        if (null == backLogMap) {
            // 查询API执行异常任务卡信息
            backLogMap = backlogMapper.getInternalErrorActivityDataByBacklogId(workitemId);
            if (backLogMap != null) {
                isPtm = false;
                // 设置tmPattern、tmCategory
                backLogMap.setTmPattern(ApiExecuteErrorConstant.TM_PATTERN);
                backLogMap.setTmCategory(ApiExecuteErrorConstant.TM_CATEGORY);
                backLogMap.setTmShowFlow(Boolean.FALSE);
                backLogMap.setProcessCreateTime(backLogMap.getTaskStartTime());

                backLogMap.setTmTaskId(ApiExecuteErrorConstant.TM_TASK_ID);
                backLogMap.setTmActivityId(ApiExecuteErrorConstant.TM_ACTIVITY_ID);
            }
        }

        if (backLogMap == null) {
            throw ErrorCodeEnum.ACTIVITY_CAN_NOT_FIND.getBusinessExceptionWithArgs(workitemId);
        }

        if (backLogMap.getOverdueWorkitemId() != null && backLogMap.getOverdueWorkitemId() > 0) {
            backLogMap.setTmTaskId(ApiExecuteErrorConstant.TM_TASK_ID);
            backLogMap.setTmActivityId(GlobalConstant.OVERDUE_WORKITEM_ACTIVITY_CODE);
            backLogMap.setTmPattern(GlobalConstant.OVERDUE_WORKITEM_PATTER);
            backLogMap.setTmCategory(GlobalConstant.OVERDUE_WORKITEM_CATEGORY);
            backLogMap.setTmShowFlow(false);

            if (!Objects.equals(backLogMap.getDataFrom(), BpmConstant.DATA_FROM_PTM)) {
                Backlog originalBacklog = backlogMapper.selectFirstByActivityStepId(backLogMap.getStepId());
                backLogMap.setPerformerId(originalBacklog.getPerformerId());
                backLogMap.setPerformerName(originalBacklog.getPerformerName());
                backLogMap.setPlanEndTime(originalBacklog.getEndTime());
            }
            backLogMap.setTmActivityName(GlobalConstant.OVERDUE_BACKLOG_NAME);
            backLogMap.setBacklogName(GlobalConstant.OVERDUE_BACKLOG_NAME);
            //逾时任务卡永远不用代理token
            backLogMap.setProxyToken(null);
        }
        //数据一致性异常卡类型
        if (abnormalWorkitem != null) {
            backLogMap.setType(abnormalWorkitem.getType());
        }

        for (ActivityDataBO activityDataBO : list) {
            if (!isPtm) {
                BpmActivityWorkitem workItem = BpmActivityWorkitem.builder()
                        .id(activityDataBO.getWorkItemId())
                        .activityStepId(activityDataBO.getStepId())
                        .performerId(activityDataBO.getPerformerId())
                        .performerName(activityDataBO.getPerformerName())
                        .workitemId(activityDataBO.getBpmWorkItemId())
                        .sourceWorkitemId(activityDataBO.getSourceWorkitemId())
                        .createType(activityDataBO.getCreateType())
                        .state(activityDataBO.getState())
                        .subState(activityDataBO.getSubState())
                        .agentPerformerId(activityDataBO.getAgentPerformerId())
                        .agentPerformerName(activityDataBO.getAgentPerformerName())
                        .comment(activityDataBO.getComment())
                        .performerType(activityDataBO.getPerformerType())
                        .overdueWorkitemId(activityDataBO.getOverdueWorkitemId())
                        .type(activityDataBO.getType())
                        .createType(activityDataBO.getCreateType())
                        .groupId(activityDataBO.getGroupId())
                        .build();
                if (activityDataBO != null) {
                    if (Objects.equals(activityDataBO.getType(), GlobalConstant.ASSIST_TYPE)) {
                        //辅助执行者，查找真正的执行人信息
                        List<BpmActivityWorkitem> workitemList = bpmActivityWorkitemMapper.selectNormalByStepSqlId(workItem.getActivityStepId());
                        if (CollectionUtils.isEmpty(workitemList)) {
                            activityDataBO.setWorkitemList("[" + JsonUtils.objectToString(workItem) + "]");
                        } else {
                            activityDataBO.setWorkitemList("[" + JsonUtils.objectToString(workitemList.get(0)) + "]");
                        }
                    } else {
                        activityDataBO.setWorkitemList("[" + JsonUtils.objectToString(workItem) + "]");
                    }
                } else {
                    activityDataBO.setWorkitemList(null);
                }
            }
            if (backLogMap.getType() == 89) {
                activityDataBO.setBacklogName(GlobalConstant.DATA_UNIFORMITY_BACKLOG_NAME);
                activityDataBO.setPlanEndTime(null);
            }
        }


        Map<String, Object> map = getActions(list, "", isPtm);
        map.put(BpmConstant.DATA_FROM_NAME, backLogMap.getDataFrom());


        processSolve(workitemId, backLogMap, map);
        processApproval(workitemId, backLogMap, map);
        processReplyInvite(workitemId, backLogMap.getTmCategory(), map);
        processApprove(backLogMap, map);

        //添加退回重签信息
        BpmActivityWorkitem workitem = bpmActivityWorkitemMapper.selectReapprovalInfoById(workitemId);
        if (workitem == null) {
            workitem = commonPtmTransformService.getReapprovalInfoById(workitemId);
        }
        map.put("reapprovalInfo", workitem);

        /*获取异动数据 start*/
        List<Long> workitemIdList = list.stream().map(ActivityDataBO::getWorkItemId).collect(Collectors.toList());
        List<Map> differentDataList = businessKeyService.queryDifferentDataByWorkitemId(authoredUser.getTenantId(), workitemIdList);
        List<BpmActivityWorkitem> dataUniformifyTask = businessKeyService.queryDataUniformifyTasks(workitemId);
        map.put("abnormalData", differentDataList);
        //异动数据主卡链接异动数据卡
        map.put("abnormalCards", dataUniformifyTask);
        /*获取异动数据 end*/
        map.put("type", backLogMap.getType());
        map.put("abnormalWorkitemId", workitemId);
        //获取唯一提交标识
        map.put("submitId",this.getSubmitId(workitemId));
        return map;
    }

    /**
     * 获取提交唯一键
     * @param workItemId
     * @return
     */
    private Integer getSubmitId(Long workItemId) {
        Integer submitId = null;
        if (workItemId != null) {
            submitId = ptmBacklogMapper.selectSubIdBatByBackId(workItemId);
        }
        return submitId;
    }

    /**
     * 处理查看签核历程，例如在 采购发起 中显示 签核历程
     *
     * @param workitemId
     * @param backLogMap
     * @param map
     */
//    private void processApproval(long workitemId, ActivityDataDTO backLogMap, Map<String, Object> map) {
//        //如果是非签核类型，不需要处理查看签核历程
//        if (Objects.equals(backLogMap.getTmCategory(), TmTaskCategory.SOLVE.getValue())) {
//            //排除异常排除类型的，因为异常排除的签核历程在每一行中
//            return;
//        }
//        String tmTaskId = backLogMap.getTmTaskId();
//        String tmActivityId = backLogMap.getTmActivityId();
//        String targetApproveActivity = getTargetApproveActivity(tmTaskId, tmActivityId);
//        if (org.apache.commons.lang.StringUtils.isBlank(targetApproveActivity)) {
//            return;
//        }
//
//        Map<String, Object> signProgressMap = new HashMap<>();
//        signProgressMap.put("processSerialNumber", backLogMap.getProcessSerialNumber());
//        List<String> activityIds = new ArrayList<>();
//        activityIds.add(targetApproveActivity);
//        signProgressMap.put("tmActivityIds", activityIds);
//        signProgressMap.put("workitemId", workitemId);
//        List tasks = (List) map.get("tasks");
//        if (!CollectionUtils.isEmpty(tasks)) {
//            Map task = (Map) tasks.get(0);
//            task.put("relationApproval", signProgressMap);
//        }
//    }

    /**
     * 回复型任务注册邀请
     *
     * @param workitemId
     * @param tmCategory
     * @param map
     */
    private void processReplyInvite(long workitemId, String tmCategory, Map<String, Object> map) {
        if (Objects.equals(tmCategory, TmTaskCategoryEnum.REPLY.getValue())) {
            BpmWorkitemAppendix appendix = bpmWorkitemAppendixService.getByBacklogId(workitemId);
            if (appendix != null && !Objects.equals(appendix.getErrorCode(), WorkitemAppendixType.ReSend.getValue())) {
                Map appendixMap = new HashMap();
                appendixMap.put("backlogId", appendix.getId());
                appendixMap.put("errorCode", appendix.getErrorCode());
                appendixMap.put("email", appendix.getEmail());
                appendixMap.put("supplierName", appendix.getSupplierName());

                List tasks = (List) map.get("tasks");
                if (!CollectionUtils.isEmpty(tasks)) {
                    Map task = (Map) tasks.get(0);
                    task.put("replyInvite", appendixMap);
                }
            }
        }
    }

    private void processSolve(long workitemId, ActivityDataBO backLogMap, Map<String, Object> map) {
        if (Objects.equals(TmTaskPatternEnum.BUSINESS.getValue(), backLogMap.getTmPattern())
                && Objects.equals(TmTaskCategoryEnum.SOLVE.getValue(), backLogMap.getTmCategory())) {
            //异常排除的，检查是否可以撤回
            JSONArray jsonArray = new JSONArray();
            Map<String, List<String>> startApproveMap = new HashMap<>();
            List<Map> actList = bpmActivityMapper.selectNoFinishedListByOriginBacklogId(workitemId);
            if (CollectionUtils.isEmpty(actList)) {
                actList = ptmBacklogTransformService.selectNoFinishedListByOriginBacklogIdForSolve(workitemId);
            }
            for (Map m : actList) {
                JSONObject dataJson = JSONObject.fromObject(m.get("data"));
                if (!dataJson.containsKey("originalQueryVariableName")) {
                    continue;
                }
                String detailField = null;
                if (dataJson.containsKey("detailField") && dataJson.get("detailField") != null) {
                    detailField = dataJson.getString("detailField");
                }
                String tmTaskId = m.get("tm_task_id").toString();
                String tmActivityId = m.get("tm_activity_id").toString();
                List<String> startApproveIdList = null;
                if (startApproveMap.containsKey(tmActivityId)) {
                    //任务id相同，定义相同
                    startApproveIdList = startApproveMap.get(tmActivityId);
                } else {
                    startApproveIdList = getStartApproveActivity(tmTaskId, tmActivityId);
                    startApproveMap.put(tmActivityId, startApproveIdList);
                }

                if (!CollectionUtils.isEmpty(startApproveIdList) && startApproveIdList.contains(backLogMap.getTmActivityId())) {
                    //能撤回,如果是审核关卡，且审核关卡的发起任务ID是当前任务，能撤回
                    Map<String, Object> terminateMap = new HashMap<>();
                    if (m.containsKey(BpmConstant.DATA_FROM_NAME) && Objects.equals(m.get(BpmConstant.DATA_FROM_NAME), BpmConstant.DATA_FROM_PTM)) {
                        terminateMap.put("serialNumber", m.get("processSerialNumber"));
                        terminateMap.put("performerId", m.get("personInCharge"));
                        terminateMap.put("performerType", 0);
                        terminateMap.put("comment", "");
                    } else {
                        BpmActivityStep activityStep = bpmActivityStepMapper.selectNoCompletedByBpmActivitySqlId(Long.valueOf(m.get("bpmActivitySqlId").toString()));
                        JSONObject workItem = (JSONObject) activityStep.getWorkitemList().getJSONObject(0);
                        terminateMap.put("processSerialNumber", m.get("process_serial_number"));
                        terminateMap.put("performerId", workItem.get("performerId"));
                        terminateMap.put("workitemId", workItem.get("workitemId"));
                        terminateMap.put("comment", "");
                        terminateMap.put("locale", LocaleContextHolder.getLocale().toString());
                    }
                    JSONArray dataKeys = dataJson.getJSONArray(dataJson.getString("originalQueryVariableName"));
                    List<JSONObject> detailAllDataKeys = getDetailAllDataKeys(dataKeys, detailField);
                    for (int i = 0; i < dataKeys.size(); i++) {
                        JSONObject dkJson = dataKeys.getJSONObject(i);
                        if (detailField != null && dkJson.containsKey(detailField)) {
                            JSONArray subKeys = dkJson.getJSONArray(detailField);
                            for (Object o : subKeys) {
                                JSONObject kv = new JSONObject();
                                kv.put("dataKey", o);
                                kv.put("processParameter", terminateMap);
                                kv.put("allKey", detailAllDataKeys);
                                jsonArray.add(kv);
                            }
                        } else {
                            JSONObject kv = new JSONObject();
                            kv.put("dataKey", dkJson);
                            kv.put("processParameter", terminateMap);
                            kv.put("allKey", dataKeys);
                            jsonArray.add(kv);
                        }
                    }
                }
            }

            if (!CollectionUtils.isEmpty(jsonArray)) {
                List tasks = (List) map.get("tasks");
                if (!CollectionUtils.isEmpty(tasks)) {
                    tasks.forEach(task -> {
                        Map taskMap = (Map) task;
                        taskMap.put("abortDataKeys", jsonArray);
                    });
                }
            }
        }
    }

    private List<JSONObject> getDetailAllDataKeys(JSONArray dataKeys, String detailField) {
        List<JSONObject> result = new ArrayList<>();

        for (int i = 0; i < dataKeys.size(); i++) {
            JSONObject dkJson = dataKeys.getJSONObject(i);
            if (detailField != null && dkJson.containsKey(detailField)) {
                result.addAll(dkJson.getJSONArray(detailField));
            }
        }

        return result;
    }

    /**
     * 获取签核信息
     *
     * @param backLogMap
     * @param map
     */
    private void processApprove(ActivityDataBO backLogMap, Map<String, Object> map) {
        if (backLogMap == null || StringUtils.isEmpty(backLogMap.getWorkitemList())
                || !PatternCategoryUtil.isApproval(backLogMap.getTmCategory())) {
            return;
        }

        //只处理签核
        JSONArray jsonArray = JSONArray.fromObject(backLogMap.getWorkitemList());
        String workItemId = jsonArray.getJSONObject(0).getString("workitemId");
        if (StringUtils.isEmpty(workItemId)) {
            return;
        }
        //只处理任务引擎
        if (!Objects.equals(BpmConstant.DATA_FROM_PTM, backLogMap.getDataFrom())) {
            return;
        }
        //是否已签核
        if (CollectionUtils.isEmpty(this.getPreApproveList(workItemId).getActivities())) {
            return;
        }
        map.put("hasApprove", true);
    }

    private BpmTaskApprovePreviousActivityDTO getPreApproveList(String workItemId) {
        BpmTaskPreApproveRequestDTO requestDTO = BpmTaskPreApproveRequestDTO.builder()
                .locale(LocaleContextHolder.getLocale().toLanguageTag())
                .workitemId(workItemId)
                .build();
        return taskEngineService.queryPreApprove(requestDTO);
    }

    private List<String> getStartApproveActivity(String tmTaskId, String tmActivityId) {

        TmActivityResponseDTO resonse = themeMapService.getActivityAction(tmTaskId, tmActivityId, TmPageName.TASK_CARD_NAME.getValue());
        return resonse.getStartApproveActivity();
    }

//    private String getTargetApproveActivity(String tmTaskId, String tmActivityId) {
//        //sonar:Rename this method; there is a "private" method in the parent class with the same name.
//        return themeMapService.getActivityTargetCode(tmTaskId, tmActivityId, TmPageName.TASK_CARD_NAME.getValue());
//    }

    public Object getViewActions(long taskId, String tmActivityId) {

        List<ActivityDataBO> activityDataBOS = null;
        //perf:打开项目详情，getEditActions基于目前大部分数据是任务引擎，优先查询ptm数据，减少一次数据库查询连接和耗时 start
        boolean isPtm = true;
        activityDataBOS = commonPtmTransformService.getViewActionsByProjectId(taskId, tmActivityId);
        if (CollectionUtils.isEmpty(activityDataBOS)) {
            //继续查询PTM
            activityDataBOS = bpmActivityMapper.selectActivityDataByTaskId(taskId, tmActivityId);
            // 处理代理人信息
            handleAgent(activityDataBOS);
            isPtm = false;
        }
        //perf:打开项目详情，getEditActions基于目前大部分数据是任务引擎，优先查询ptm数据，减少一次数据库查询连接和耗时 end
        return getActions(activityDataBOS, "", isPtm);
    }

    private void handleAgent(List<ActivityDataBO> activityDataBOS) {

        if (CollectionUtil.isEmpty(activityDataBOS)){
            return;
        }
        // 查询租户下所有用户信息
        List<EocTenantAllUserDTO.EocUserDTO> allUser = eocService.getAllUserByTenant();
        activityDataBOS.forEach(activityDataDTO -> {

            ProxyUserResp proxyUser = eocService.getProxyUser(activityDataDTO.getPerformerId(), AppAuthContextHolder.getContext().getAuthoredUser().getToken());
            if (null != proxyUser){
                activityDataDTO.setPerformerAgentId(proxyUser.getUserId());
                activityDataDTO.setPerformerAgentName(getUserNameById(proxyUser.getUserId(), allUser));
            }
        });

    }

    private String getUserNameById(String userId, List<EocTenantAllUserDTO.EocUserDTO> allUser) {

        if (StringUtils.isEmpty(userId)){
            return null;
        }

        Optional<EocTenantAllUserDTO.EocUserDTO> optional = allUser.stream().filter(eocUserDTO -> userId.equals(eocUserDTO.getUserId())).findFirst();
        return optional.map(EocTenantAllUserDTO.EocUserDTO::getUserName).orElse(null);
    }

    /**
     * 已废弃
     * 任务引擎 Action
     *
     * @Author：SYQ
     * @Date：2021/8/8 11:32
     */
//    public Object getTaskEngineViewActions(String taskIds, String tmActivityId, String activityPass, String routeIds) {
//        List<ActivityDataDTO> activityDataDTOS = null;
//        if (StringUtil.isNotEmpty(taskIds) && StringUtil.isNotEmpty(tmActivityId)) {
//            String[] taskIdArr = taskIds.split(",");
//            //根据节点路径、项目id和路线id获取bpm_activity_id
//            QueryWrapper queryWrapper = new QueryWrapper();
//            queryWrapper.eq("pass", activityPass);
//            queryWrapper.in("task_id", taskIdArr);
//            List<RouteDetail> routeDetailList = routeDetailMapper.selectList(queryWrapper);
//            if (routeDetailList != null && routeDetailList.size() > 0) {
//                List<Long> bpmActivityIdList = new ArrayList<>();
//                for (RouteDetail routeDetail : routeDetailList) {
//                    bpmActivityIdList.add(routeDetail.getBpmActivityId());
//                }
//                //根据bpm_activity_id和task_id查询任务信息
//                activityDataDTOS = bpmActivityMapper.selectTaskEngineTaskActivityData(tmActivityId, taskIds.split(","), bpmActivityIdList);
//
//            }
//        }
//        boolean isPtm = false;
//        if (CollectionUtils.isEmpty(activityDataDTOS)) {
//            activityDataDTOS = commonPtmTransformService.selectTaskEngineProjectCardActivityData(taskIds, activityPass);
//            isPtm = true;
//        }
//        return getActions(activityDataDTOS, BpmEngineCategory.TaskEngine.getCategory(), isPtm);
//    }


    private Map<String, Object> getActions(List<ActivityDataBO> list, String engineType, boolean isPtm) {

        if (CollectionUtils.isEmpty(list) || list.get(0) == null) {
            return null;
        }
        //todo:效率优化，暂时去掉，有问题找陈旭松
        //添加前置任务信息
//        for (ActivityDataDTO activityDataDTO : list) {
//            //如果有前置任务，则获取前置任务信息
//            if (StringUtils.hasText(activityDataDTO.getPreTaskUid())) {
//                BpmActivityWorkitem bpmActivityWorkitem = bpmActivityWorkitemMapper.selectLastSubmitWorkItem(activityDataDTO.getPreTaskUid());
//                if (bpmActivityWorkitem != null) {
//                    activityDataDTO.setPrePerformerId(bpmActivityWorkitem.getPerformerId());
//                    activityDataDTO.setPrePerformerName(bpmActivityWorkitem.getPerformerName());
//                    activityDataDTO.setPreAgentPerformerId(bpmActivityWorkitem.getAgentPerformerId());
//                    activityDataDTO.setPreAgentPerformerName(bpmActivityWorkitem.getAgentPerformerName());
//                    activityDataDTO.setPrePerformerType(bpmActivityWorkitem.getPerformerType());
//                }
//            }
//        }
        Map<String, Object> root = new HashMap<>();

        ActivityDataBO activityDataBO = list.get(0);
        Map<String, Object> project = new HashMap<>();
        root.put("project", project);
        project.put("projectId", activityDataBO.getTaskId());
        project.put("tmProjectId", activityDataBO.getTmTaskId());
        project.put("chargeId", activityDataBO.getChargeId());
        project.put("chargeName", activityDataBO.getChargeName());
        project.put("tenantId", activityDataBO.getTenantId());
        project.put("startTime", activityDataBO.getTaskStartTime());
        project.put("endTime", activityDataBO.getTaskEndTime());
        project.put("projectName", activityDataBO.getTaskName());
        project.put("processCreateTime", activityDataBO.getProcessCreateTime());
        project.put("projectBpmData", activityDataBO.getProjectBpmData() == null ? null : JsonUtils.jsonToObject(activityDataBO.getProjectBpmData(), Map.class));

        if (!StringUtils.isEmpty(activityDataBO.getTaskSourceIds())) {
            List<String> ids = new ArrayList<>();
            for (String item : activityDataBO.getTaskSourceIds().split(",")) {
                ids.add(item);
            }
            project.put("sourceIds", ids);
        }

        List<String> processSerialNumberList = new ArrayList<>();
        for (ActivityDataBO dataDTO : list) {
            String key = dataDTO.getProcessSerialNumber() + dataDTO.getTaskUid();
            if (!processSerialNumberList.contains(key)) {
                processSerialNumberList.add(key);
            }
        }


        List<Map<String, Object>> tasks = new ArrayList<>();
        root.put("tasks", tasks);
        for (String processSerialNumber : processSerialNumberList) {
            List<ActivityDataBO> activities = list.stream().filter(x -> (x.getProcessSerialNumber() + x.getTaskUid()).equals(processSerialNumber))
                    .collect(Collectors.toList());

            //降序排列，取最新的
            Collections.sort(activities, (o1, o2) -> {
                if (o1.getBacklogId() != null && o2.getBacklogId() != null) {
                    return o2.getBacklogId().compareTo(o1.getBacklogId());
                } else {
                    return o2.getBpmActivitySqlId().compareTo(o1.getBpmActivitySqlId());
                }
            });
            Optional<ActivityDataBO> activityOpt = activities.stream().findFirst();
            if (activityOpt.isPresent()) {
                activityDataBO = activityOpt.get();
            }

            Map<String, Object> taskObject = new HashMap<>();
            tasks.add(taskObject);

            taskObject.put("processSerialNumber", activityDataBO.getProcessSerialNumber());
            taskObject.put("bpmActivitySqlId", activityDataBO.getBpmActivitySqlId());
            taskObject.put("bpmData", activityDataBO.getBpmData() == null ? null : JsonUtils.jsonToObject(activityDataBO.getBpmData(), Map.class));
            taskObject.put("stateData", activityDataBO.getBpmStateData() == null ? null : JsonUtils.jsonToObject(activityDataBO.getBpmStateData(), Map.class));
            taskObject.put("tmActivityId", activityDataBO.getTmActivityId());
            taskObject.put("compositionId", activityDataBO.getCompositionId());
            taskObject.put("tmCategory", activityDataBO.getTmCategory());
            taskObject.put("tmPattern", activityDataBO.getTmPattern());
            taskObject.put("bpmActivityId", activityDataBO.getBpmActivityId());
            taskObject.put("bpmActivityType", activityDataBO.getBpmActivityType());
            taskObject.put("performerIds", activityDataBO.getPerformerIds() == null ? null : JsonUtils.jsonToObject(activityDataBO.getPerformerIds(), new ArrayList<String>().getClass()));
            taskObject.put("businessUnit", activityDataBO.getBusinessUnit() == null ? null : JsonUtils.jsonToObject(activityDataBO.getBusinessUnit(), Map.class));
            taskObject.put("tmActivityName", activityDataBO.getTmActivityName());
            taskObject.put("proxyToken", activityDataBO.getProxyToken());
            taskObject.put("traceId", activityDataBO.getTraceId());
            taskObject.put("type", activityDataBO.getType());
            taskObject.put("taskUid", activityDataBO.getTaskUid());

            //增加营运单元信息
            List<String> eocNames = new ArrayList();
            if (!StringUtils.isEmpty(activityDataBO.getEocName()) && !eocNames.contains(activityDataBO.getEocName())) {
                eocNames.add(activityDataBO.getEocName());
            }
            taskObject.put("eocName", eocNames);

            if (!StringUtils.isEmpty(activityDataBO.getApprovalState())) {
                taskObject.put("approvalState", GlobalConstant.backlogStatusMap.getOrDefault(activityDataBO.getApprovalState(), ""));
                taskObject.put("isRapprovalInfoShow", activityDataBO.getApprovalState());
            }

            //backlog
            List<Map<String, Object>> backlogs = new ArrayList<>();
            taskObject.put("backlog", backlogs);

            for (ActivityDataBO dataDTO : activities) {
                if (dataDTO.getBacklogId() == null) {
                    continue;
                }

                Integer submitId = ptmBacklogMapper.selectSubIdBatByBackId(dataDTO.getPtmBacklogId());

                Map<String, Object> backlog = new HashMap<>();
                backlogs.add(backlog);

                backlog.put("backlogId", dataDTO.getWorkItemId());
                // 执行者的租户id
                backlog.put("targetTenantId", dataDTO.getTargetTenantId());
                backlog.put("performerId", dataDTO.getPerformerId());
                backlog.put("performerName", dataDTO.getPerformerName());
                backlog.put("performerAgentId", dataDTO.getPerformerAgentId());
                backlog.put("performerAgentName", dataDTO.getPerformerAgentName());
                backlog.put("performerState", dataDTO.getPerformerState());
                backlog.put("readCount", dataDTO.getReadCount());
                backlog.put("startTime", dataDTO.getStartTime());
                backlog.put("planEndTime", dataDTO.getPlanEndTime());
                backlog.put("endTime", dataDTO.getEndTime());
                backlog.put("closed", dataDTO.getBacklogClosed());
                backlog.put("backlogName", dataDTO.getBacklogName());
                backlog.put("ptmBacklogId", dataDTO.getPtmBacklogId());
                backlog.put("submitId", submitId);
                backlog.put("ptmWorkItemId", dataDTO.getPtmWorkItemId());
                backlog.put("merge", dataDTO.getMerge());
                backlog.put("planEndTimeMin", dataDTO.getPlanEndTimeMin());
                backlog.put("planEndTimeMax", dataDTO.getPlanEndTimeMax());
                backlog.put("createType", dataDTO.getCreateType());

                //增加营运单元信息
                if (!StringUtils.isEmpty(dataDTO.getEocName()) && !eocNames.contains(dataDTO.getEocName())) {
                    eocNames.add(dataDTO.getEocName());
                }

                //如果有前置任务，则获取前置任务信息
                //chenxsa 效率优化去掉
//                if (StringUtils.hasText(dataDTO.getPreTaskUid())){
//                    BpmActivityWorkitem preWorkItem = bpmActivityWorkitemMapper.selectLastSubmitWorkItem(dataDTO.getPreTaskUid());
//                    if (preWorkItem != null){
//                        backlog.put("prePerformerId", dataDTO.getPrePerformerId());
//                        backlog.put("prePerformerName", dataDTO.getPrePerformerName());
//                        backlog.put("preAgentPerformerId", dataDTO.getPreAgentPerformerId());
//                        backlog.put("preAgentPerformerName", dataDTO.getPreAgentPerformerName());
//                        backlog.put("prePerformerType", dataDTO.getPrePerformerType());
//                    }
//                }

                if (dataDTO.getEndTime() == null) {
                    if (dataDTO.getMerge() && isPtm) {
                        //倒计时
                        backlog.put("remainTime", TimeUtils.dateInterval(LocalDateTime.now(), dataDTO.getPlanEndTimeMin()));
                        //逾期
                        backlog.put("overdueDate", TimeUtils.dateInterval(dataDTO.getPlanEndTimeMin(), LocalDateTime.now()));
                    } else {
                        //倒计时
                        backlog.put("remainTime", TimeUtils.dateInterval(LocalDateTime.now(), dataDTO.getPlanEndTime()));
                        //逾期
                        backlog.put("overdueDate", TimeUtils.dateInterval(dataDTO.getPlanEndTime(), LocalDateTime.now()));
                    }
                }
                backlog.put("workitemList", dataDTO.getWorkitemList() == null ? null : JsonUtils.jsonToObject(dataDTO.getWorkitemList(), tasks.getClass()));
                //如果有就返回，不判断是否完成
                backlog.put("finishedActionId", dataDTO.getFinishedActionId());
                if (StringUtils.isEmpty(dataDTO.getFinishedActionId()) && Objects.equals(3, dataDTO.getStepState())) {
                    //如果没有结束按钮，且已结束，特殊处理终止、撤销等状态
                    if (Objects.equals(ActivityWorkitemSubState.END_TASK_UNDO.getValue(), dataDTO.getStepSubState())) {
                        //已撤销
                        backlog.put("finishedActionId", "athena_bpm_cancel");
                    } else {
                        //其他情况，赋值已结束
                        backlog.put("finishedActionId", "uibot_action_id_finished");
                    }
                }
                backlog.put("bpmSignReason", dataDTO.getStepSignReason());

                //暂时只取一个，后期支持会签和或签的时候，还需要处理
                if (!Objects.equals(engineType, BpmEngineCategoryEnum.TaskEngine.getCategory())) {
                    break;
                }
            }
        }
        return root;
    }

//    /**
//     * 生成数据状态
//     * @param authoredUser
//     * @param bpmActivity
//     * @param bpmProcess
//     * @param task
//     */
//    public void generateDataState(AuthoredUser authoredUser, BpmActivity bpmActivity, BpmProcess bpmProcess, Task task){
//
//        try {
//            if (bpmActivity.getState().equals(ActivityState.EXECUTEING.getValue())) {
//                Long backlogId = 0L;
//                Backlog backlog = backlogMapper.selectFirstUnClosedByBpmActivityId(bpmActivity.getId());
//                if (backlog == null) {
//                    BacklogItem backlogItem = backlogItemMapper.selectFirstUnClosedByBpmActivitySqlId(bpmActivity.getId());
//                    backlogId = backlogItem.getBacklogId();
//                } else {
//                    backlogId = backlog.getId();
//                }
//
//                Object dataObject = getEditActions(authoredUser,backlogId);
//                BaseResultDTO<JSONObject> dataJSON = aglieService.queryData(authoredUser.getToken(), dataObject);
//
//                Map<String, Object> data = new HashMap<>();
//                data.put("processSerialNumber", bpmProcess.getProcessSerialNumber());
//                data.put("compositionId", bpmProcess.getCompositionId());
//                data.put("tmActivityId", bpmActivity.getActivityId());
//                data.put("tmTaskId", task.getTmTaskId());
//                data.put("data", dataJSON.getResponse());
//
//                atdmService.generateBusinessKey(authoredUser.getToken(), data);
//
//            }
//        }catch (Exception ex){
//
//        }
//    }

    /**
     * 转派任务
     *
     * @param workitem
     * @param newPerformerId
     * @param comment
     * @param user
     */
    public void reassignTask(BpmActivityWorkitem workitem, String newPerformerId, String comment, AuthoredUser user) {

        BpmActivityStep step = bpmActivityStepMapper.selectById(workitem.getActivityStepId());
        BpmActivity bpmActivity = bpmActivityMapper.selectById(step.getActivityId());

        String processSerialNumber = bpmActivity.getProcessSerialNumber();
        String performerId = workitem.getPerformerId();
        String workitemId = workitem.getWorkitemId();
        String bpmActivityId = step.getBpmActivityId();
        bpmService.reassignWorkitem(processSerialNumber, bpmActivityId, workitemId, performerId, newPerformerId, comment);

    }


    public Map<String, Object> getMainEditActions(AuthoredUser authoredUser, long workitemId, Boolean isHistory) {
        BpmActivityWorkitem bpmActivityWorkitem = bpmActivityWorkitemMapper.selectById(workitemId);
        if (bpmActivityWorkitem != null) {
            workitemId = (bpmActivityWorkitem.getGroupId() != 0L) ? bpmActivityWorkitem.getGroupId() : workitemId;
        } else {
            PtmWorkItemRecordBO ptmWorkItemRecor = ptmService.getWorkItemRecord(workitemId);
            if (ptmWorkItemRecor != null) {
                workitemId = ptmWorkItemRecor.getBacklogId();
            }
        }
        return getEditActions(authoredUser, workitemId, isHistory);
    }
}
