package com.digiwin.athena.atmc.common.service.backlog;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.digiwin.athena.appcore.util.TimeUtils;
import com.digiwin.athena.atmc.application.service.query.commontype.CardPresentConfigQryService;
import com.digiwin.athena.atmc.common.constant.ApiExecuteErrorConstant;
import com.digiwin.athena.atmc.common.domain.CardInfoDto;
import com.digiwin.athena.atmc.common.domain.CardItemDto;
import com.digiwin.athena.atmc.core.meta.enums.km.TmTaskCategoryEnum;
import com.digiwin.athena.atmc.core.meta.enums.km.TmTaskPatternEnum;
import com.digiwin.athena.atmc.infrastructure.mapper.biz.migration.BacklogMapper;
import com.digiwin.athena.atmc.common.dao.BpmActivityMapper;
import com.digiwin.athena.atmc.common.dao.BpmActivityWorkitemMapper;
import com.digiwin.athena.atmc.common.dao.TaskWorkitemMessageMapper;
import com.digiwin.athena.atmc.common.domain.BpmActivity;
import com.digiwin.athena.atmc.common.domain.TaskWorkitemMessage;
import com.digiwin.athena.atmc.common.domain.backlog.CardAbstractDTO;
import com.digiwin.athena.atmc.common.domain.ptm.PtmDataInfo;
import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.BacklogBO;
import com.digiwin.athena.atmc.common.mock.MockData;
import com.digiwin.athena.atmc.common.service.bpmworkitemappendix.BpmWorkitemAppendixService;
import com.digiwin.athena.atmc.common.service.project.CommonProjectHandleService;
import com.digiwin.athena.atmc.common.service.ptm.CommonPtmTransformService;
import com.digiwin.athena.atmc.common.util.ActivityUtils;
import com.digiwin.athena.atmc.common.util.BacklogAbstractUtil;
import com.digiwin.athena.atmc.http.constant.BpmConstant;
import com.digiwin.athena.atmc.http.constant.ErrorCodeEnum;
import com.digiwin.athena.atmc.core.meta.constants.GlobalConstant;
import com.digiwin.athena.atmc.http.constant.ManualTaskConstant;
import com.digiwin.athena.atmc.infrastructure.pojo.po.migration.Backlog;
import com.digiwin.athena.atmc.http.restful.aglie.AglieService;
import com.digiwin.athena.atmc.http.restful.iam.UserService;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmBacklogRecordDTO;
import com.digiwin.athena.atmc.http.restful.thememap.ThemeMapService;
import com.digiwin.athena.atmc.http.restful.thememap.model.*;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.*;

/**
 * 任务卡的摘要服务(新)
 */
@Slf4j
@Service
public class CommonBacklogAbstractService {

    @Autowired
    private ThemeMapService themeMapService;

    @Autowired
    private AglieService aglieService;

    @Autowired
    private BacklogActionCreateService backlogActionCreateService;

    @Autowired
    private BpmBacklogActionCreateService bpmBacklogActionCreateService;

    @Autowired
    private BpmActivityWorkitemMapper bpmActivityWorkitemMapper;

    @Autowired
    private UserService userService;

    @Autowired
    private BpmWorkitemAppendixService bpmWorkitemAppendixService;

    @Autowired
    private CommonPtmTransformService commonPtmTransformService;

    @Autowired
    private BpmActivityMapper bpmActivityMapper;

    @Autowired
    private BacklogMapper backlogMapper;

    @Autowired
    private MessageUtils messageUtils;

    @Autowired
    TaskWorkitemMessageMapper taskWorkitemMessageMapper;

    @Resource
    private BacklogAbstractUtil backlogAbstractUtil;

    @Resource
    private CommonProjectHandleService commonProjectHandleService;

    private static final String SUMMARY_LAYOUT_STR = "summaryLayoutStr";

    private static final String BACKLOG_OVERDUE_TASK_MSG = "backlog.overdue.task.msg";

    public static final String PTM_BACKLOG = "ptmBacklog";

    @Autowired
    private CardPresentConfigQryService cardPresentConfigQryService;

    public TmActivityResponseDTO getTaskCardPageDefineByWorkItemId(long workItemId) {
        BacklogBO backlogBO = backlogMapper.selectBacklogForCard(workItemId);
        if (null == backlogBO) {
            backlogBO = commonPtmTransformService.selectBacklogForCard(workItemId);
            if (null == backlogBO) {
                return null;
            }
            backlogBO.setDataFrom(BpmConstant.DATA_FROM_PTM);
        }

        // 应用行事历任务支持查询概要信息
        if (ManualTaskConstant.VIRTUAL_PROJECT.equals(backlogBO.getTmTaskId())) {
            // 流程变量
            String bpmData = backlogBO.getBpmData();
            if (org.apache.commons.lang.StringUtils.isEmpty(bpmData)) {
                return null;
            }
            JSONObject bpmDataObj = JSONObject.fromObject(bpmData);
            // 若taskCode和tmActivityId都不存在则不是应用行事历任务
            if (!bpmDataObj.containsKey(ManualTaskConstant.BpmDataKey.TASK_CODE)
                    && !bpmDataObj.containsKey(ManualTaskConstant.BpmDataKey.TM_ACTIVITY_ID)) {
                return null;
            }
            // 获取行事历的code
            String tmActivityId = StringUtils.isEmpty(bpmDataObj.getString(ManualTaskConstant.BpmDataKey.TASK_CODE))
                    ? bpmDataObj.getString(ManualTaskConstant.BpmDataKey.TM_ACTIVITY_ID)
                    : bpmDataObj.getString(ManualTaskConstant.BpmDataKey.TASK_CODE);
            // 若code等于uibotManualTask则不是应用行事历
            if (ManualTaskConstant.MANUAL_TASK_ID.equals(tmActivityId)) {
                return null;
            }
            backlogBO.setCalendar(true);
            backlogBO.setTmActivityId(tmActivityId);
        }

        if (backlogBO.getOverdueWorkitemId() != null && backlogBO.getOverdueWorkitemId() > 0) {
            backlogBO.setTmTaskId(ApiExecuteErrorConstant.TM_TASK_ID);
            backlogBO.setTmActivityId(GlobalConstant.OVERDUE_WORKITEM_ACTIVITY_CODE);
        }
        return themeMapService.getActivityAction(backlogBO.getTmTaskId(), backlogBO.getTmActivityId(),
                TmPageName.TASK_CARD_NAME.getValue());
    }


    private Map<String, Object> initMap(Map<String, Object> result) {
        if (result == null) {
            return new HashMap<>();
        }
        return result;
    }

    /**
     * 获取任务卡标题
     *
     * @param ptmDataInfo
     * @return
     */
    public Map<String, Object> getCardTitle(PtmDataInfo ptmDataInfo) {
        Map<String, Object> task = ptmDataInfo.getTask();
        if (task == null) {
            task = new HashMap<>();
            ptmDataInfo.setTask(task);
        }
        Map<String, Object> project = ptmDataInfo.getProject();
        if (project == null) {
            project = new HashMap<>();
            ptmDataInfo.setProject(project);
        }
        Map<String, Object> activity = ptmDataInfo.getActivity();
        if (activity == null) {
            activity = new HashMap<>();
            ptmDataInfo.setActivity(activity);
        }
        Map<String, Object> workItem = ptmDataInfo.getWorkItem();
        if (workItem == null) {
            workItem = new HashMap<>();
            ptmDataInfo.setWorkItem(workItem);
        }
        String taskId = MapUtils.getString(project, "projectDefCode");
        Map<String, Object> result;
        Map<String, Object> activityData;
        String tmActivityId = null;
        activityData = backlogActionCreateService.getPtmAction(ptmDataInfo);
        if (BooleanUtils.isNotTrue(ptmDataInfo.getProjectCard())) {
            tmActivityId = MapUtils.getString(task, "taskDefCode");
            if(StringUtils.isBlank(tmActivityId)){
                return new HashMap<>();
            }
            // 需要判断行事历
            if (ManualTaskConstant.VIRTUAL_PROJECT.equals(taskId) && ManualTaskConstant.MANUAL_TASK_ID.equals(tmActivityId)) {
                activityData.put("calendar", true);
            }
        }
        log.info("获取标题数据:{}", JsonUtils.objectToString(activityData));
        BaseResultDTO<Map<String, Object>> taskCardTitle = aglieService.getTaskCardTitle(taskId, tmActivityId, activityData);
        result = taskCardTitle.getResponse();
        log.info("标题:{}", result);
        return result;
    }

    @MockData(type = "detail")
    public Map getBacklogCardAbstractById(long workItemId, AuthoredUser user, boolean needHistoryInfo) {
        return getBacklogCardAbstractById(workItemId, user, new CardAbstractDTO().setNeedHistoryInfo(needHistoryInfo).setEnableQueryApi(false),null);
    }


    private BacklogBO getBacklogBoByItemIdOrBacklogId(long id){
        BacklogBO backlogBO = commonPtmTransformService.selectBacklogForCard(id);
        backlogBO.setDataFrom(BpmConstant.DATA_FROM_PTM);

        Map<String, Object> checkItems_map = new HashMap<>();
        if (backlogBO.getOverdueWorkitemId() != null && backlogBO.getOverdueWorkitemId() > 0) {
            backlogBO.setName(GlobalConstant.OVERDUE_BACKLOG_NAME);
            backlogBO.setTmTaskId(ApiExecuteErrorConstant.TM_TASK_ID);
            backlogBO.setTmActivityId(GlobalConstant.OVERDUE_WORKITEM_ACTIVITY_CODE);
            backlogBO.setTmPattern(GlobalConstant.OVERDUE_WORKITEM_PATTER);
            backlogBO.setTmCategory(GlobalConstant.OVERDUE_WORKITEM_CATEGORY);

            Backlog originalBacklog = getOriginalBacklog(backlogBO.getOverdueWorkitemId());
            List<Map<String, Object>> checkItems = new ArrayList<>();
            backlogBO.setCheckItems(checkItems);
            checkItems_map.put("item",
                    messageUtils.getMessageWithFormat(BACKLOG_OVERDUE_TASK_MSG,
                            MessageUtils.getMessageByCurrentLanguage(originalBacklog.getName()),
                            TimeUtils.dateInterval(originalBacklog.getEndTime(), LocalDateTime.now())));
            checkItems.add(checkItems_map);
            backlogBO
                    .setOperation(MessageUtils.getMessageByCurrentLanguage(GlobalConstant.OVERDUE_WORKITEM_OPERATION));
        }
        // 数据一致性异常排除任务卡
        if (GlobalConstant.DATA_UNIFORMITY_BACKLOG_TYPE.equals(backlogBO.getType())) {
            backlogBO.setName(GlobalConstant.DATA_UNIFORMITY_BACKLOG_NAME);
        }
        return backlogBO;
    }



    /**
     * 获取任务卡摘要拼接信息
     *
     * @param workItemId
     * @param user
     * @return
     */
    @MockData(type = "detail")
    public Map getBacklogCardAbstractById(long workItemId, AuthoredUser user, CardAbstractDTO cardAbstractDTO,String langName) {
        BacklogBO backlogBO = getBacklogBoByItemIdOrBacklogId(workItemId);
        boolean enableQueryApi = true;
        if (!Objects.equals(GlobalConstant.OVERDUE_WORKITEM_PATTER, backlogBO.getTmPattern())
                || !Objects.equals(GlobalConstant.OVERDUE_WORKITEM_CATEGORY, backlogBO.getTmCategory())) {
            TmActivityResponseDTO themeActivity = themeMapService.getActivityAction(backlogBO.getTmTaskId(), backlogBO.getTmActivityId(),
                    TmPageName.TASK_CARD_NAME.getValue());
            setCheckItems(user, backlogBO,themeActivity);
            if(!cardAbstractDTO.isEnableQueryApi() && themeActivity.getPages() != null){
                TmActivityPageDTO pages = themeActivity.getPages();
                enableQueryApi = BooleanUtils.isNotFalse(pages.getEnableQueryApi());
                if(!enableQueryApi){
                    // TmDataState配置需要调用uibot生成卡片右上角加上一个标记，业务上代表某种特殊状态的卡片，比如人员上线这些
                    TmDataState dataState = pages.getDataStates().stream().filter(e->!"all".equals(e.getType())).findFirst().orElse(null);
                    if(dataState != null){
                        List<TmActivityStates> taskStates = dataState.getTaskStates();
                        if(CollectionUtils.isNotEmpty(taskStates)){
                            enableQueryApi = true;
                        }
                    }
                }

            }
        }
        Map<String, Object> summaryLayoutStr = null;
        if(enableQueryApi){
            summaryLayoutStr = setSummaryLayoutStr(user, backlogBO, cardAbstractDTO,langName);
        }else {
           // 查询存储的摘要配置
            QueryWrapper<TaskWorkitemMessage> queryWrapper = new QueryWrapper<>();
            queryWrapper.select("summary","history_message","search_message");
            queryWrapper.eq("card_id",workItemId);
            queryWrapper.eq("card_type",PTM_BACKLOG);

            List<TaskWorkitemMessage> workitemMessageList = taskWorkitemMessageMapper.selectList(queryWrapper);
            if(CollectionUtils.isNotEmpty(workitemMessageList)){
                TaskWorkitemMessage taskWorkitemMessage = workitemMessageList.get(0);
                summaryLayoutStr = Maps.newHashMapWithExpectedSize(3);
                summaryLayoutStr.put(SUMMARY_LAYOUT_STR,taskWorkitemMessage.getSummary());
                summaryLayoutStr.put("historyMessage",taskWorkitemMessage.getHistoryMessage());
                summaryLayoutStr.put("searchMessage",taskWorkitemMessage.getSearchMessage());
            }

        }
//        Map<String, Object> summaryLayoutStr = setSummaryLayoutStr(user, backlogBO, cardAbstractDTO,langName);
        String reapprovalInfoComment = "";
        // 开启实时查询才查询退回意见,历史的摘要已经存储退回意见
        if(enableQueryApi){
            reapprovalInfoComment = getReApprovalComment(workItemId,backlogBO,null);
        }
        Map<String, Object> checkItemsMap = new HashMap<>();
        if (summaryLayoutStr != null) {
            checkItemsMap.put("summaryLayout", getSummaryStr(reapprovalInfoComment, summaryLayoutStr));
            checkItemsMap.put("historyMessage", summaryLayoutStr.get("historyMessage"));
            checkItemsMap.put("searchMessage", summaryLayoutStr.get("searchMessage"));
            checkItemsMap.put("cardState", summaryLayoutStr.get("cardState"));
        } else {
            if (!StringUtils.isEmpty(reapprovalInfoComment)) {
                checkItemsMap.put("summaryLayout", reapprovalInfoComment);
            }
        }

        String checkItemsStr = "";
        if (backlogBO.getCheckItems() != null) {
            checkItemsStr = backlogBO.getCheckItems().get(0).get("item").toString();
            if (backlogBO.getCheckItems().get(0).get("value") != null) {
                int value_i = Integer.parseInt(backlogBO.getCheckItems().get(0).get("value").toString());
                if (value_i != 0) {
                    checkItemsStr = checkItemsStr + backlogBO.getCheckItems().get(0).get("value").toString();
                }
            }

            checkItemsMap.put("checkItems", checkItemsStr);
        }
        if (backlogBO.getOperation() != null) {
            String operationStr = backlogBO.getOperation();
            checkItemsMap.put("operation", operationStr);
        }
        if (!CollectionUtils.isEmpty(backlogBO.getTodoItems())) {
            String todoItemStr = backlogBO.getTodoItems().get(0).get("item").toString();
            checkItemsMap.put("todoItems", todoItemStr);
        }
        if (backlogBO.getError() != null) {
            checkItemsMap.put("error", backlogBO.getError().get("error").toString());
        }

        // 设置卡面呈现配置
        cardPresentConfigQryService.setCardPresentConfigs(checkItemsMap,TmPageName.TASK_CARD_NAME.getValue());

        return checkItemsMap;
    }

    public CardInfoDto getSummaryWorkItemLayout(Long backlogId,BacklogBO backlogBO,Map<String, Object> editActions, AuthoredUser user, CardAbstractDTO cardAbstractDTO){
        editActions.put("needHistoryInfo", cardAbstractDTO.getNeedHistoryInfo());
        editActions.put("calendar", backlogBO.getCalendar());
        // 分批查询
        Object o = editActions.get("tasks");
        CardInfoDto cardInfoDto = new CardInfoDto();
        try {
            if(o instanceof List){
                List<Map<String,Object>> taskList = (List<Map<String, Object>>) o;
                // 第一步
                if(CollectionUtils.isEmpty(taskList)){
                    return null;
                }
                List<CardItemDto> dtoList = Lists.newArrayListWithExpectedSize(taskList.size());
                if(taskList.size()>1){ // 代表有合并任务
                    Map<Long,Map<String,Object>> activityToData = Maps.newHashMapWithExpectedSize(taskList.size());
                    for (Map<String, Object> task : taskList) {
                        Long id = MapUtils.getLong(task, "ptmActivityId");
                        if(id != null){
                            activityToData.put(id,task);
                            continue;
                        }
                        Object o1 = task.get("backlog");
                        if(o1 instanceof Map){
                            Map<String,Object> backlog = (Map<String, Object>) o1;
                            Object o2 = backlog.get("workitemList");
                            if(o2 instanceof List){
                                List<Map<String,Object>> workitemList = (List<Map<String, Object>>) o2;
                                if(CollectionUtils.isNotEmpty(workitemList)){
                                    Map<String, Object> workItem = workitemList.get(0);
                                    activityToData.put(MapUtils.getLong(workItem,"activityStepId"),task);
                                }
                            }
                        }
                    }
                    if(activityToData.size()>1){
                        activityToData.forEach((k,v)->{
                            editActions.put("tasks",Lists.newArrayList(v));
                            BaseResultDTO<Map> actionResponse = aglieService.getTaskCardAbstractStr(backlogBO.getTmTaskId(),
                                    backlogBO.getTmActivityId(), backlogBO.getId(), editActions,null,null);
                            Map<String, Object> pageDataMap = actionResponse.getResponse();
                            dtoList.add(new CardItemDto(k,pageDataMap));
                        });
                    }else {
                        BaseResultDTO<Map> actionResponse = aglieService.getTaskCardAbstractStr(backlogBO.getTmTaskId(),
                                backlogBO.getTmActivityId(), backlogBO.getId(), editActions,null,null);
                        Map<String, Object> pageDataMap = actionResponse.getResponse();
                        dtoList.add(new CardItemDto(null,pageDataMap));
                    }
                }else {
                    BaseResultDTO<Map> actionResponse = aglieService.getTaskCardAbstractStr(backlogBO.getTmTaskId(),
                            backlogBO.getTmActivityId(), backlogBO.getId(), editActions,null,null);
                    Map<String, Object> pageDataMap = actionResponse.getResponse();
                    dtoList.add(new CardItemDto(null,pageDataMap));
                }
                cardInfoDto.setCardItemList(dtoList);
            }
            editActions.put("tasks",o);
            // 是否存储业务字段信息
            addBusinessMessage(cardAbstractDTO,editActions,user,backlogBO);
        }catch (Exception e){
            log.warn(e.getMessage(), e);
        }
        String reapprovalInfoComment = getReApprovalComment(backlogId,backlogBO,null);
        Map<String, Object> summaryInfo = Maps.newHashMapWithExpectedSize(10);
        cardInfoDto.setReApprovalComment(reapprovalInfoComment);
        List<CardItemDto> cardItemList = cardInfoDto.getCardItemList();
        if(CollectionUtils.isNotEmpty(cardItemList)){
            for (CardItemDto cardItemDto : cardItemList) {
                Map<String, Object> cardInfo = cardItemDto.getCardInfo();
                String summaryStr = getSummaryStr(reapprovalInfoComment, cardInfo);
                cardInfo.put("summaryLayout",summaryStr);
                summaryInfo.put("summaryLayout",mergeMessage(MapUtils.getString(summaryInfo,"summaryLayout"),summaryStr));
                summaryInfo.put("historyMessage",mergeMessage(MapUtils.getString(summaryInfo,"historyMessage"),MapUtils.getString(summaryInfo,"historyMessage")));
                summaryInfo.put("searchMessage",mergeMessage(MapUtils.getString(summaryInfo,"searchMessage"),MapUtils.getString(summaryInfo,"searchMessage")));
            }
        }

        cardInfoDto.setCardInfo(summaryInfo);
        return cardInfoDto;
    }

    public CardInfoDto getSummaryWorkItemLayout(long backlogId, AuthoredUser user, CardAbstractDTO cardAbstractDTO){
        BacklogBO backlogBO = getBacklogBoByItemIdOrBacklogId(backlogId);
        Map<String, Object> editActions = bpmBacklogActionCreateService.getEditActions(user, backlogBO.getId(), null);
        return getSummaryWorkItemLayout(backlogId,backlogBO,editActions,user,cardAbstractDTO);
    }

    public String mergeMessage(String message, String subMessage) {
        /**
         * 简单合并：直接比较subMessage和message是否相同，相同则返回message；不相同，subMessage追加到message
         */
        if (StringUtils.isBlank(message)) {
            return subMessage;
        }

        if (StringUtils.equals(message, subMessage) || StringUtils.isBlank(subMessage)) {
            return message;
        }

        return message + "<br>" + subMessage;
    }






    /**
     * 获取退回意见
     * @param id
     * @param cacheCode
     * @return
     */
    public String getReApprovalComment(Long id,Map<String,String> cacheCode){
        BacklogBO backlogBO = commonPtmTransformService.selectBacklogForCard(id);
        return getReApprovalComment(id,backlogBO,cacheCode);
    }

    private String getReApprovalComment(Long id,BacklogBO backlogBO,Map<String,String> cacheCode){
        if(backlogBO != null){
            // 退回意见，只要退回都显示，若以后重新发起不要显示，把if代码放开即可(排除异常任务)
            boolean isAbnormal = org.springframework.util.StringUtils.pathEquals(TmTaskPatternEnum.BUSINESS.getValue(),
                    backlogBO.getTmPattern())
                    && org.springframework.util.StringUtils.pathEquals(TmTaskCategoryEnum.SOLVE.getValue(),
                    backlogBO.getTmCategory());
            boolean isApproval = Objects.equals(backlogBO.getTmPattern(), TmTaskPatternEnum.BUSINESS.getValue())
                    && Objects.equals(backlogBO.getTmCategory(), TmTaskCategoryEnum.APPROVAL.getValue());
            // 非异常任务可取退回意见
            if(!isAbnormal){
                if (isApproval) {
                    return getReApprovalComment(id);
                }else {
                    String targetApproveActivity;
                    if(cacheCode != null){
                         targetApproveActivity = cacheCode.computeIfAbsent(backlogBO.getTmTaskId() + "#" + backlogBO.getTmActivityId(), k -> themeMapService.getActivityTargetCode(backlogBO.getTmTaskId(),
                                backlogBO.getTmActivityId(), TmPageName.TASK_CARD_NAME.getValue()));
                    }else {
                        targetApproveActivity = themeMapService.getActivityTargetCode(backlogBO.getTmTaskId(),
                                backlogBO.getTmActivityId(), TmPageName.TASK_CARD_NAME.getValue());
                    }
                    if(StringUtils.isNotBlank(targetApproveActivity)){
                        return getReApprovalComment(id);
                    }
                }
            }
        }
        return null;
    }


    public String getReApprovalComment(Long id){
        // 根据workItemId获取退回重签意见
        String comment = commonPtmTransformService.getExecuteComment(id);
        if (!StringUtils.isEmpty(comment)) {
            return messageUtils.getMessage("reapproval.info.comment") + comment;
        }
        return "";
    }


    private String getSummaryStr(String reapprovalInfoComment,Map<String, Object> summaryLayoutStr){
        if(StringUtils.isEmpty(reapprovalInfoComment)){
            return org.apache.commons.collections4.MapUtils.getString(summaryLayoutStr,SUMMARY_LAYOUT_STR);
        }
        String summary = org.apache.commons.collections4.MapUtils.getString(summaryLayoutStr, SUMMARY_LAYOUT_STR);
        if(StringUtils.isEmpty(summary)){
            return reapprovalInfoComment;
        }
        return reapprovalInfoComment + "<br>"+summary;


    }


    private Map setSummaryLayoutStr(AuthoredUser authoredUserm, BacklogBO backlogBO, CardAbstractDTO cardAbstractDTO, String langName) {
        Map<String, Object> activityDataMap = backlogActionCreateService.getEditActions(authoredUserm, backlogBO.getId(), null);
        Map<String, Object> cardAbstractMap = null;
        try {
            activityDataMap.put("needHistoryInfo", cardAbstractDTO.getNeedHistoryInfo());
            activityDataMap.put("calendar", backlogBO.getCalendar());
            BaseResultDTO<Map> actionResponse = aglieService.getTaskCardAbstractStr(backlogBO.getTmTaskId(),
                    backlogBO.getTmActivityId(), backlogBO.getId(), activityDataMap,cardAbstractDTO.getCount(),langName);
            cardAbstractMap = actionResponse.getResponse();
        } catch (Exception e) {
            log.warn(e.getMessage(), e);
            Map<String, Object> error = new HashMap<>();
            error.put("error", e.getMessage());
            backlogBO.setError(error);
        }
        // 业务数据获取和入库
        addBusinessMessage(cardAbstractDTO,activityDataMap,authoredUserm,backlogBO);
        return cardAbstractMap == null ? Maps.newHashMap() : cardAbstractMap;
    }

    private void addBusinessMessage(CardAbstractDTO cardAbstractDTO,Map<String, Object> activityDataMap,AuthoredUser authoredUserm, BacklogBO backlogBO){
        if(BooleanUtils.isTrue(cardAbstractDTO.getNeedBusinessMessage())){
            activityDataMap.put("businessMessageSourceType", cardAbstractDTO.getBusinessMessageSourceType());
            activityDataMap.put("cardId", cardAbstractDTO.getCardId());
            activityDataMap.put("pageCode", TmPageName.TASK_CARD_NAME.getValue());
            activityDataMap.put("tmTaskId", backlogBO.getTmTaskId());
            activityDataMap.put("tmActivityId", backlogBO.getTmActivityId());
            activityDataMap.put("tenantId", authoredUserm.getTenantId());
            log.info("流程变量数据存入id:{}",cardAbstractDTO.getCardId());
            backlogAbstractUtil.getAndSaveBusinessMessage(activityDataMap);
        }

    }

    /**
     *  刷新业务字段 目前abt使用
     * @param authoredUserm
     * @param cardAbstractDTO
     */
    public void saveTaskSaveBusinessMessage(AuthoredUser authoredUserm,CardAbstractDTO cardAbstractDTO){
        Long cardId = cardAbstractDTO.getCardId();
        BacklogBO backlogBO = commonPtmTransformService.selectBacklogForCard(cardId);
        if(backlogBO != null && backlogBO.getTmActivityId() != null){
            Object activityData = backlogActionCreateService.getEditActions(authoredUserm, backlogBO.getId(), null);
            if(activityData instanceof Map){
                Map activityDataMap = (Map) activityData;
                activityDataMap.put("businessMessageSourceType", cardAbstractDTO.getBusinessMessageSourceType());
                activityDataMap.put("cardId", cardId);
                activityDataMap.put("pageCode", TmPageName.TASK_CARD_NAME.getValue());
                activityDataMap.put("tmTaskId", backlogBO.getTmTaskId());
                activityDataMap.put("tmActivityId", backlogBO.getTmActivityId());
                activityDataMap.put("tenantId", authoredUserm.getTenantId());
                log.info("流程变量数据存入id:{}",cardId);
                backlogAbstractUtil.getAndSaveBusinessMessage(activityDataMap);
            }
        }
    }


    public Backlog getOriginalBacklog(Long overdueWorkitemId) {
        return commonPtmTransformService.translateBacklogById(overdueWorkitemId);
    }

    public void setCheckItems(AuthoredUser authoredUser, BacklogBO backlogBO){
        if (Objects.equals(GlobalConstant.OVERDUE_WORKITEM_PATTER, backlogBO.getTmPattern())
                && Objects.equals(GlobalConstant.OVERDUE_WORKITEM_CATEGORY, backlogBO.getTmCategory())) {
            return;
        }
        setCheckItems(authoredUser,backlogBO,null);
    }


    public void setCheckItems(AuthoredUser authoredUser, BacklogBO backlogBO,TmActivityResponseDTO themeActivity) {
        String tmTaskId = backlogBO.getTmTaskId();
        if(themeActivity == null){
            themeActivity = themeMapService.getActivityAction(tmTaskId, backlogBO.getTmActivityId(),
                    TmPageName.TASK_CARD_NAME.getValue());
            backlogBO.setSubName(themeActivity.getStartApproveActivityName());
        }
        if (Objects.equals("MECHANISM", backlogBO.getTmPattern())
                && Objects.equals("SUGGESTION", backlogBO.getTmCategory())) {
            setReasonToCheckItems(backlogBO, themeActivity);
            return;
        } else if (Objects.equals("MECHANISM", backlogBO.getTmPattern())
                && Objects.equals("APPROVAL", backlogBO.getTmCategory())) {
            setMechanismAppovalCheckItems(backlogBO, themeActivity);
            return;
        } else if (Objects.equals("ADJUSTMENT", backlogBO.getTmPattern())
                && Objects.equals("ADJUSTMENT", backlogBO.getTmCategory())) {
            setReasonToCheckItems(backlogBO, themeActivity);
            return;
        } else if (Objects.equals("MECHANISM", backlogBO.getTmPattern())
                && Objects.equals("POSITIONSUGGESTION", backlogBO.getTmCategory())) {
            setReasonToCheckItems(backlogBO, themeActivity);
            return;
        } else if (Objects.equals("MECHANISM", backlogBO.getTmPattern())
                && Objects.equals("POSITIONAPPROVAL", backlogBO.getTmCategory())) {
            setReasonToCheckItems(backlogBO, themeActivity);
            return;
        }

        boolean needCountData = true;
        if (themeActivity.hasCheckItems()) {
            backlogBO.setCheckItems(ActivityUtils.getCheckItemsResult(themeActivity.getCheckItems(), 0));
            needCountData = false;
        }

        // 设置建议操作
        if (themeActivity.hasOperations()) {
            Optional<TmOperationDTO> tmOperation = themeActivity.getPages().getOperations().stream().findFirst();
            tmOperation.ifPresent(tmOperationDTO -> backlogBO.setOperation(tmOperationDTO.getDescription()));

            needCountData = false;
        }

        if (themeActivity.existSummaryFields()) {
            needCountData = false;
        }

        if (needCountData) {
            setTodo(authoredUser, backlogBO);
        }

        backlogBO.setBpmActivityId(null);
    }

    /**
     * 将reson设置checkItems
     *
     * @param backlogBO
     * @param tmActivityResponseDTO
     */
    public void setReasonToCheckItems(BacklogBO backlogBO, TmActivityResponseDTO tmActivityResponseDTO) {
        if (tmActivityResponseDTO.getPages() == null || tmActivityResponseDTO.getPages().getReason() == null) {
            return;
        }
        TmReasonDTO reasonDTO = tmActivityResponseDTO.getPages().getReason();

        List<Map<String, Object>> checkItems = new ArrayList<>();
        backlogBO.setCheckItems(checkItems);

        Map<String, Object> checkItemMap = new HashMap<>();
        checkItemMap.put("item", MessageUtils.getMessageByCurrentLanguage(reasonDTO.getTitle()));
        checkItems.add(checkItemMap);

        if (!"ADJUSTMENT".equals(tmActivityResponseDTO.getPattern()) && reasonDTO.getContent() != null) {
            // checkItemMap=new HashMap<>();
            // checkItemMap.put("item",MessageUtils.getMessageByCurrentLanguage(reasonDTO.getContent().getText()));
            // checkItems.add(checkItemMap);
            backlogBO.setOperation(MessageUtils.getMessageByCurrentLanguage(reasonDTO.getContent().getText()));
        }
    }

    /**
     * 机制型审核活动卡的checkItems特殊处理，使用新公式的每一项
     *
     * @param backlogBO
     * @param tmActivityResponseDTO
     */
    public void setMechanismAppovalCheckItems(BacklogBO backlogBO, TmActivityResponseDTO tmActivityResponseDTO) {
        Map<String, TmActionDTO> dataSources = tmActivityResponseDTO.getDataSources();
        if (MapUtils.isEmpty(dataSources) || !dataSources.containsKey("newFormulaData")) {
            return;
        }

        TmActionDTO newFormulaAction = dataSources.get("newFormulaData");
        List<TmActionParameterDTO> paras = newFormulaAction.getActionParams();
        if (org.springframework.util.CollectionUtils.isEmpty(paras)) {
            return;
        }
        BpmActivity bpmActivity = bpmActivityMapper.selectById(backlogBO.getBpmActivityId());
        if (bpmActivity == null || bpmActivity.getData() == null) {
            return;
        }

        Optional<TmActionParameterDTO> formulaIdNameOption = paras.stream().findFirst();
        String formulaIdName = "";
        if (formulaIdNameOption.isPresent()) {
            formulaIdName = formulaIdNameOption.get().getValue();
        }

        String formulaId = bpmActivity.getData().getString(formulaIdName);
        Map formulaMap = themeMapService.executeFormula(formulaId);
        if (!formulaMap.containsKey("formulaVariables")) {
            return;
        }
        List<Map> formulaVariables = (List<Map>) formulaMap.get("formulaVariables");

        List<Map<String, Object>> checkItems = new ArrayList<>();
        backlogBO.setCheckItems(checkItems);
        for (Map m : formulaVariables) {
            Map<String, Object> map = new HashMap<>();
            map.put("item", m.get("name"));
            map.put("value", m.get("value"));
            checkItems.add(map);
        }

    }

    public void setTodo(AuthoredUser authoredUser, BacklogBO backlogBO) {

        Object activityData = bpmBacklogActionCreateService.getEditActions(authoredUser, backlogBO.getId(), null);
        try {
            BaseResultDTO<HashMap> actionResponse = aglieService.getTaskCardDataSize(backlogBO.getTmTaskId(),
                    backlogBO.getTmActivityId(), activityData);
            HashMap data = actionResponse.getResponse();

            if (data == null || data.size() == 0 || !data.containsKey("title")) {
                return;
            }
            List<Map<String, Object>> todo = new ArrayList<>();
            Map<String, Object> ci = new HashMap<>();

            String langName = getLangName(authoredUser.getUserId(), authoredUser.getToken());
            Map<String, Object> activityDataMap = (Map<String, Object>) activityData;
            if (activityDataMap.get("type") != null && Integer.parseInt(activityDataMap.get("type").toString()) == 89) {
                ci.put("item", String.format(
                        messageUtils.getMessageByLangName("data.uniformity.exception.size", langName), data.get("size")));
            } else {
                String item = MessageFormat.format("{0}{1}{2}", data.get("title"), data.get("size"),
                        messageUtils.getMessageByLangName("data.summary.term", langName));
                if (data.containsKey("abnormalSize") && Integer.parseInt(data.get("abnormalSize").toString()) > 0) {
                    item = item + "，"
                            + String.format(messageUtils.getMessageByLangName("data.uniformity.abnormal.size", langName),
                            data.get("abnormalSize"));
                }
                ci.put("item", item);
            }
            todo.add(ci);
            backlogBO.setTodoItems(todo);
        } catch (Exception e) {
            log.warn(e.getMessage(), e);
            Map<String, Object> error = new HashMap<>();
            error.put("error", e.getMessage());
            backlogBO.setError(error);
        }
    }

    /**
     * 获取语言
     *
     * @param userId
     * @param token
     * @return
     */
    private String getLangName(String userId, String token) {

        // 优先取header 传入的语言
        HttpServletRequest httpServletRequest = ((ServletRequestAttributes) (RequestContextHolder
                .currentRequestAttributes())).getRequest();
        String locale = httpServletRequest.getHeader("Locale");
        if (StringUtils.isNotBlank(locale)) {
            return locale;
        }
        // 查询用户语言设置
        String langName = userService.getUserLangMetadataAllTenant(userId, token);
        if (StringUtils.isNotBlank(langName)) {
            return langName;
        }
        // 如果上面都未获取到语言类别，返回默认值
        return "zh_TW";
    }

    public void resetTaskWorkItem(AuthoredUser user, PtmBacklogRecordDTO ptmBacklogRecord, String dataVariableKey) {
        Object activityData = bpmBacklogActionCreateService.getEditActions(user, ptmBacklogRecord.getId(), null);
        Map activityDataMap = (Map) activityData;
        activityDataMap.put("needHistoryInfo", false);
        activityDataMap.put("calendar", false);
        activityDataMap.put("dataVariableKey", dataVariableKey);
        try {
            BaseResultDTO<Map> actionResponse = aglieService.getTaskCardLayoutAbstractUpToDate(ptmBacklogRecord.getProjectDefCode(),
                    ptmBacklogRecord.getTaskDefCode(), ptmBacklogRecord.getId(), activityDataMap, null);
            Map<String, Object> pageDataMap = actionResponse.getResponse();
            String summaryLayout = "";
            String historyMessage = "";
            String searchMessage = "";
            if (MapUtils.isNotEmpty(pageDataMap)) {
                summaryLayout = pageDataMap.get("summaryLayoutStr").toString();
                historyMessage = pageDataMap.get("historyMessage").toString();
                searchMessage = pageDataMap.get("searchMessage").toString();
            }
            TaskWorkitemMessage taskWorkitemMessage = new TaskWorkitemMessage();
            taskWorkitemMessage.setId(SnowflakeIdWorker.getInstance().newId());
            taskWorkitemMessage.setTenantId(user.getTenantId());
            taskWorkitemMessage.setCardId(ptmBacklogRecord.getId());
            taskWorkitemMessage.setCreateDate(LocalDateTime.now());
            taskWorkitemMessage.setModifyDate(LocalDateTime.now());
            taskWorkitemMessage.setSummary(summaryLayout);
            taskWorkitemMessage.setHistoryMessage(historyMessage);
            taskWorkitemMessage.setSearchMessage(searchMessage);
            taskWorkitemMessage.setCardType(PTM_BACKLOG);
            // TODO 需要构造活动的摘要信息
            taskWorkitemMessageMapper.insertOrUpdateMessage(taskWorkitemMessage);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            throw ErrorCodeEnum.RESET_TASK_WORKITEM_ERORR.getBusinessException();
        }
    }
}
