package com.digiwin.athena.atmc.common.service.bpm;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.atmc.infrastructure.mapper.biz.migration.BacklogMapper;
import com.digiwin.athena.atmc.common.dao.BpmActivityWorkitemMapper;
import com.digiwin.athena.atmc.common.domain.bpm.BpmActivityStepDTO;
import com.digiwin.athena.atmc.common.domain.bpm.BpmStepWorkitemDTO;
import com.digiwin.athena.atmc.common.enums.WorkitemAppendixType;
import com.digiwin.athena.atmc.common.enums.WorkitemState;
import com.digiwin.athena.atmc.infrastructure.pojo.po.migration.Backlog;
import com.digiwin.athena.atmc.infrastructure.pojo.po.migration.BpmActivityWorkitem;
import com.digiwin.athena.atmc.http.restful.cac.model.AppAuthDTO;
import com.digiwin.athena.atmc.http.restful.cac.CacService;
import com.digiwin.athena.atmc.http.restful.iam.BossIamService;
import com.digiwin.athena.atmc.http.restful.iam.UserService;
import com.digiwin.athena.atmc.http.restful.iam.model.BossIamAddUserResultDTO;
import com.digiwin.athena.atmc.http.restful.iam.model.BossIamCheckUserResultDTO;
import com.digiwin.athena.atmc.http.restful.iam.model.InnerExistDTO;
import com.digiwin.athena.atmc.http.restful.iam.model.UserDTO;
import com.digiwin.athena.atmc.http.restful.thememap.ThemeMapService;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmAppDTO;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.*;

/**
 * BPM 任务共用服务
 */
@Slf4j
@Service
public class BpmActivityService {

    /**
     * 通用租户中注册的应用名称
     */
    private static String APP_NAME = "athena";

    @Autowired
    private BacklogMapper backlogMapper;

    @Autowired
    private BpmActivityWorkitemMapper bpmActivityWorkitemMapper;

    @Autowired
    private BossIamService bossIamService;

    @Autowired
    private ThemeMapService themeMapService;

    @Autowired
    private CacService cacService;

    @Autowired
    private UserService userService;

    /**
     * 关闭BPM关卡所关联的待办项
     * @param bpmStepId
     */
    public void closedBackLogByBpmStepId(long bpmStepId){

        QueryWrapper<Backlog> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("bpm_activity_step_id", bpmStepId)
                .eq("closed", 0)
                .select("id,closed");
        List<Backlog> backlogList = backlogMapper.selectList(queryWrapper);

        if(CollectionUtils.isNotEmpty(backlogList)){
            backlogMapper.batchCloseBacklog(backlogList);
        }
    }

    /**
     * 关闭逾时卡
     * @param bpmStepId
     */
    public void closeSpecialWorkitemByBpmStepId(long bpmStepId){

        List<BpmActivityWorkitem> workitemList = bpmActivityWorkitemMapper.selectSpecialByStepSqlId(bpmStepId);
        for (BpmActivityWorkitem bpmActivityWorkitem : workitemList) {
            if(!Objects.equals(bpmActivityWorkitem.getState(), WorkitemState.COMPLETED.getValue()) && bpmActivityWorkitemMapper.selectChildCount(bpmActivityWorkitem.getId())<=0){
                bpmActivityWorkitem.setState(WorkitemState.COMPLETED.getValue());
                bpmActivityWorkitem.setClosedTime(LocalDateTime.now());
                bpmActivityWorkitemMapper.updateById(bpmActivityWorkitem);
            }
        }

    }

    /**
     * 检查是否有用户,并注册用户
     * @param targetTenantId
     * @param email
     * @return 注册的用户Id，userId
     */
    public String registerUser( String targetTenantId, String email){

        try {
            BossIamCheckUserResultDTO checkUserResultDTO = bossIamService.checkTenantUser(targetTenantId, APP_NAME, email);
            if (checkUserResultDTO != null && Objects.equals(checkUserResultDTO.getUserExisted(), Boolean.TRUE)) {
                return checkUserResultDTO.getUserId();
            }

            BossIamAddUserResultDTO result = bossIamService.addTenantUser(targetTenantId, email, "digiwinAthena", APP_NAME);
//            Map map = bossIamService.addTenantUser(targetTenantId, email, RandomUtil.genRandomStr(8), APP_NAME);
            return result.getData().getUserId();
        }
        catch (Exception e){
            log.warn("注册企业用户失败 {}", e);
        }
        return null;
    }

//    /**
//     * 检查当前租户是否有用户和应用
//     * @param tmTaskId
//     * @param sourceTenantId
//     * @param email
//     * @return 注册的用户Id，userId
//     */
//    public String checkAppAndUser(String tmTaskId, String sourceTenantId, String email){
//
//        try {
//            List<TmAppDTO> appList = themeMapService.getAppsByProjectIdForFlowEngine(tmTaskId);
//            if (CollectionUtils.isEmpty(appList)) {
//                return null;
//            }
//
//            for (TmAppDTO tmAppDTO : appList) {
//                BossIamCheckUserResultDTO checkUserResultDTO = bossIamService.checkTenantUser(sourceTenantId, tmAppDTO.getAppCode(), email);
//                if (checkUserResultDTO != null && Objects.equals(checkUserResultDTO.getUserExisted(), Boolean.TRUE)
//                    && Objects.equals(checkUserResultDTO.getAuthExisted(), Boolean.TRUE)) {
//                    return checkUserResultDTO.getUserId();
//                }
//            }
//        }
//        catch (Exception e){
//            log.error("检查用户就用失败：", e);
//        }
//        return null;
//    }

    /**
     * 如果是协作厂专区的，更换执行人
     * @param activityStepDTO
     * @param commonTenantUserId
     */
    public void updateEmailPerformerId(BpmActivityStepDTO activityStepDTO, String commonTenantUserId){
        if(activityStepDTO==null || CollectionUtils.isEmpty(activityStepDTO.getWorkitemList())){
            return;
        }

        for (BpmStepWorkitemDTO bpmStepWorkitemDTO : activityStepDTO.getWorkitemList()) {
            if(bpmStepWorkitemDTO.getState() < WorkitemState.COMPLETED.getValue() && !Objects.equals(commonTenantUserId, bpmStepWorkitemDTO.getPerformerId())){
                bpmStepWorkitemDTO.setCommonPerformerId(commonTenantUserId);
            }
        }
    }

    /**
     * 获取个人租户和用户id，若没有个人租户或者授权需要创建个人租户并授权
     * @Author：SYQ
     * @Date：2021/11/24 15:08
     */
    public Map<String,String> getTargetTenantAndUser(AuthoredUser authoredUser,String email,String phone){
        Map<String,String> resultMap = new HashMap<>();
        //获取是否已存在个人租户和用户
        Map<String,Object> tenantAuthMap = bossIamService.getTenantAuth(authoredUser,email,phone,"Athena",0);
        if(tenantAuthMap == null){
            return Collections.emptyMap();
        }
        //结果
        Integer status = Integer.valueOf(tenantAuthMap.get("status").toString());
        //处理返回值
        if(status == -1){ //调用接口失败
            return Collections.emptyMap();
        }else if(status == 0){//没有个人租户，需要去创建个人租户并且授权
            Map<String,String> registerMap = bossIamService.registerTenant(authoredUser,email,phone,
                    "Athena","","athena_light_01");
            if(registerMap != null && registerMap.size() > 0){
                resultMap.put("workItemToTenantId",registerMap.get("id"));
                resultMap.put("commonTenantUserId",registerMap.get("userId"));
            }
        }else if(status == 1){//存在个人租户但没有授权
            //租户下是否有应用授权
            Boolean isTenantAuth = Boolean.valueOf(tenantAuthMap.get("isTenantAuth").toString());
            Boolean authorizeUserResult = bossIamService.authorizeUser(authoredUser,tenantAuthMap.get("tenantId").toString(),email, phone,
                    "Athena","","athena_light_01",isTenantAuth);
            if(authorizeUserResult){
                resultMap.put("workItemToTenantId",tenantAuthMap.get("tenantId").toString());
                resultMap.put("commonTenantUserId",tenantAuthMap.get("userId").toString());
            }
        }else if(status == 2){//存在个人租户并且已授权
            resultMap.put("workItemToTenantId",tenantAuthMap.get("tenantId").toString());
            resultMap.put("commonTenantUserId",tenantAuthMap.get("userId").toString());
        }
        return resultMap;
    }

    /**
     * 根据联系方式判定当前联系信息是否正常
     * @param tenantId 租户信息
     * @param contactMessage 联系方式，目前支持 contacts:邮箱/contactPhone:手机
     * @param tmProjectCode 项目编号
     * @return
     */
    public WorkitemAppendixType getContactsType(String tenantId, JSONObject contactMessage, String tmProjectCode){
        String email = (String) contactMessage.get("contacts");
        String phone = (String) contactMessage.get("contactPhone");
        //先使用手机验证
        WorkitemAppendixType resultType = this.getMobileType(tenantId,phone,tmProjectCode);
        //手机不存在，使用email验证
        if(resultType != WorkitemAppendixType.Normal){
            resultType = this.getEmailType(tenantId,email,tmProjectCode);
        }
        return resultType;
    }

    public WorkitemAppendixType getMobileType(String tenantId, String phone, String tmProjectCode){
        try {
            if (StringUtils.isBlank(phone)) {
                //缺少email
                return WorkitemAppendixType.NoPhone;
            }

            //region 是否注册云账号
            InnerExistDTO innerExistDTO = userService.phoneInnerExist(phone);
            if(innerExistDTO==null || !Objects.equals(innerExistDTO.getIsRegister(),true)){
                //没有注册用户
                return WorkitemAppendixType.NoRegister;
            }

            //endregion

            //region 查找注册的账号

            String performerId = null;
            UserDTO userDTO = userService.queryByPhone(phone);
            if (userDTO != null && StringUtils.isNotBlank(userDTO.getId())) {
                performerId = userDTO.getId();
            }
            if (StringUtils.isBlank(performerId)) {
                //没有注册用户
                return WorkitemAppendixType.NoRegister;
            }

            //endregion

            //region 查找应用code
            List<TmAppDTO> appList = themeMapService.getAppsByProjectIdForFlowEngine(tmProjectCode);
            if (CollectionUtils.isEmpty(appList)) {
                //查询不到应用，没授权
                return WorkitemAppendixType.NoPermission;
            }
            String appCode = appList.get(0).getAppCode();

            //endregion

            //region 查找是否已加入租户
            userDTO = userService.queryByPhone(phone, tenantId);
            if(userDTO==null){
                return WorkitemAppendixType.NoTenant;
            }
            //endregion

            //region 是否有应用授权

            AppAuthDTO appAuthDTO = cacService.queryAppAuth(performerId, appCode);
            if (appAuthDTO == null || !Objects.equals(appAuthDTO.getIsSuccess(), true)) {
                //没授权
                return WorkitemAppendixType.NoPermission;
            }


        }catch (Exception ex){
            log.warn("getEmailType 获取用户注册、授权信息异常：  {}", ex);
            return WorkitemAppendixType.NoRegister;
        }

        return WorkitemAppendixType.Normal;
    }


    public WorkitemAppendixType getEmailType(String tenantId, String email, String tmProjectCode){
        try {
            if (StringUtils.isBlank(email)) {
                //缺少email
                return WorkitemAppendixType.NoEmail;
            }

            //region 是否注册云账号
            InnerExistDTO innerExistDTO = userService.emailInnerExist(email);
            if(innerExistDTO==null || !Objects.equals(innerExistDTO.getIsRegister(),true)){
                //没有注册用户
                return WorkitemAppendixType.NoRegister;
            }

            //endregion

            //region 查找注册的账号

            String performerId = null;
            UserDTO userDTO = userService.queryByEmail(email);
            if (userDTO != null && StringUtils.isNotBlank(userDTO.getId())) {
                performerId = userDTO.getId();
            }
            if (StringUtils.isBlank(performerId)) {
                //没有注册用户
                return WorkitemAppendixType.NoRegister;
            }

            //endregion

            //region 查找应用code
            List<TmAppDTO> appList = themeMapService.getAppsByProjectIdForFlowEngine(tmProjectCode);
            if (CollectionUtils.isEmpty(appList)) {
                //查询不到应用，没授权
                return WorkitemAppendixType.NoPermission;
            }
            String appCode = appList.get(0).getAppCode();

            //endregion

            //region 查找是否已加入租户
            userDTO = userService.queryByEmail(email, tenantId);
            if(userDTO==null){
                return WorkitemAppendixType.NoTenant;
            }
            //endregion

            //region 是否有应用授权

            AppAuthDTO appAuthDTO = cacService.queryAppAuth(performerId, appCode);
            if (appAuthDTO == null || !Objects.equals(appAuthDTO.getIsSuccess(), true)) {
                //没授权
                return WorkitemAppendixType.NoPermission;
            }

            //endregion

            //region 是否加入租户、授权是否已满

//            ReplyInviteResultDTO replyInviteResultDTO = userService.replyInvite(email, tenantId, appCode, null);
//            if(replyInviteResultDTO!=null){
//                if(replyInviteResultDTO.getData()==null) {
//                    //未加入指定租户
//                    return WorkitemAppendixType.NoTenant;
//                }else{
//                    if(StringUtils.isBlank(replyInviteResultDTO.getData().getCode())){
//                        //未加入指定租户
//                        return WorkitemAppendixType.NoTenant;
//                    }else if(Objects.equals(replyInviteResultDTO.getData().getCode(), "21023")){
//                        //授权已满
//                        return WorkitemAppendixType.PermissionFull;
//                    }
//                }
//            }

            //endregion

        }catch (Exception ex){
            log.warn("getEmailType 获取用户注册、授权信息异常：  {}", ex);
            return WorkitemAppendixType.NoRegister;
        }

        return WorkitemAppendixType.Normal;
    }

    /**
     * 获取BPMdata中的供应商名称
     * @param bpmData
     * @return
     */
    public String getSupplierName(JSONObject bpmData){
        String result = "未知供应商";

        if(bpmData!=null && bpmData.containsKey("emailMessage")){
            JSONObject emailMessage = bpmData.getJSONObject("emailMessage");
            if(emailMessage!=null && emailMessage.containsKey("message")){
                JSONObject message = emailMessage.getJSONObject("message");
                if(message!=null && message.containsKey("data")){
                    JSONObject data = message.getJSONObject("data");
                    if(data!=null && data.containsKey("supplier_name")){
                        result = data.getString("supplier_name");
                    }
                }
            }
        }

        return result;
    }

    /**
     * 获取BPMdata中的 联系地址
     * @param bpmData
     * @return
     */
    public String getEmail(JSONObject bpmData){
        String result = null;

        if(bpmData!=null && bpmData.containsKey("emailMessage")){
            JSONObject emailMessage = bpmData.getJSONObject("emailMessage");
            if(emailMessage!=null && emailMessage.containsKey("contacts")){
                result = emailMessage.getString("contacts");
            }
        }

        return result;
    }

    public String getContact(JSONObject bpmData){
        String result = null;

        if(bpmData!=null && bpmData.containsKey("emailMessage")){
            JSONObject emailMessage = bpmData.getJSONObject("emailMessage");
            if(emailMessage!=null && emailMessage.containsKey("contactPhone")){
                result = emailMessage.getString("contactPhone");
            }
            if(emailMessage!=null && emailMessage.containsKey("contacts")){
                result = StringUtils.isNotEmpty(emailMessage.getString("contacts")) ? emailMessage.getString("contacts") : result;
            }
        }

        return result;
    }
}
