package com.digiwin.athena.atmc.common.service.project;

import cn.hutool.core.map.MapUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.application.service.query.commontype.CardPresentConfigQryService;
import com.digiwin.athena.atmc.common.dao.TaskMapper;
import com.digiwin.athena.atmc.common.dao.TaskWorkitemMessageMapper;
import com.digiwin.athena.atmc.common.domain.BpmProcess;
import com.digiwin.athena.atmc.common.domain.TaskWorkitemMessage;
import com.digiwin.athena.atmc.common.domain.backlog.CardAbstractDTO;
import com.digiwin.athena.atmc.common.service.ptm.CommonPtmTransformService;
import com.digiwin.athena.atmc.common.util.BacklogAbstractUtil;
import com.digiwin.athena.atmc.http.domain.Task;
import com.digiwin.athena.atmc.http.restful.aglie.AglieService;
import com.digiwin.athena.atmc.http.restful.thememap.ThemeMapService;
import com.digiwin.athena.atmc.http.restful.thememap.model.*;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

/**
 * 项目卡处理服务(新)
 */
@Slf4j
@Service
public class CommonProjectHandleService {

    @Autowired
    private TaskMapper taskMapper;

    @Autowired
    TaskWorkitemMessageMapper taskWorkitemMessageMapper;

    @Autowired
    private ThemeMapService themeMapService;

    @Autowired
    private AglieService aglieService;

    @Autowired
    private CommonPtmTransformService commonPtmTransformService;

    @Resource
    private BacklogAbstractUtil backlogAbstractUtil;

    @Autowired
    private CardPresentConfigQryService cardPresentConfigQryService;


    private List<Map<String, Object>> getTasks(Long projectCardId) {
        List<Map<String, Object>> tasks = new ArrayList<>();
        List<BpmProcess> processList = commonPtmTransformService.getProjectByProjectCardId(projectCardId);
        for (BpmProcess bpmProcess : processList) {
            Map<String, Object> taskObject = new HashMap<>();
            taskObject.put("processSerialNumber", bpmProcess.getProcessSerialNumber());
            taskObject.put("bpmData", bpmProcess.getData());
            taskObject.put("businessUnit", bpmProcess.getBusinessUnit());
            taskObject.put("proxyToken", bpmProcess.getProxyToken());
            taskObject.put("tmTaskId",bpmProcess.getTmTaskId());
            tasks.add(taskObject);
        }
        return tasks;
    }

    public Map getActivityData(Task task) {
        Map project = new HashMap();
        project.put("projectId", task.getId());
        project.put("tmProjectId", task.getTmTaskId());
        project.put("chargeId", task.getPersonInCharge());
        project.put("chargeName", task.getPersonInChargeName());
        project.put("tenantId", task.getTenantId());
        project.put("startTime", task.getStartTime());
        project.put("endTime", task.getEndTime());
        project.put("projectName", task.getName());
        List<Map<String, Object>> tasks = this.getTasks(task.getId());
        Map activityData = new HashMap();
        activityData.put("project", project);
        activityData.put("tasks", tasks);

        return activityData;
    }

    /**
     * 获取项目卡本身的摘要信息，不获取其含有的任务摘要信息
     *
     * @param user
     * @param projectId
     * @return
     */
    public Map getProjectCardSelfAbstract(AuthoredUser user, long projectId,  boolean needHistoryInfo) {
        return this.getProjectCardSelfAbstract(user, projectId, new CardAbstractDTO().setNeedHistoryInfo(needHistoryInfo).setEnableQueryApi(false));
    }


    public Map getProjectActivityData(Long projectId){
        Task task = commonPtmTransformService.getTask(projectId);
        if(task != null){
            Map<String, Object> map = new HashMap<>();
            map.put("tmTaskId", task.getTmTaskId());
            map.put("projectId", projectId);
            return getActivityData(task);
        }
        return null;
    }

    public void saveProjectCardData(Long projectId){
        Task task = commonPtmTransformService.getTask(projectId);
        if(task != null){
            Map<String, Object> map = new HashMap<>();
            map.put("tmTaskId", task.getTmTaskId());
            map.put("projectId", projectId);
            Map activityData = getActivityData(task);
            activityData.put("businessMessageSourceType", CardAbstractDTO.SOURCE_TYPE_API);
            activityData.put("cardId", projectId);
            activityData.put("pageCode", TmPageName.PROJECT_CARD_NAME.getValue());
            activityData.put("tmTaskId", task.getTmTaskId());
            activityData.put("tenantId", task.getTenantId());
            backlogAbstractUtil.getAndSaveBusinessMessage(activityData);
        }

    }
    public Map getProjectCardSelfAbstract(AuthoredUser user, long projectId, CardAbstractDTO cardAbstractDTO) {
        Task task = commonPtmTransformService.getTask(projectId);
        Map<String, Object> map = new HashMap<>();
        if (task != null) {
            map.put("tmTaskId", task.getTmTaskId());
            map.put("projectId", projectId);

            Map activityData = setCheckSummaryForProjectCardAbstract(map, task, cardAbstractDTO);

            // 业务数据获取和入库
            if (activityData != null && BooleanUtils.isTrue(cardAbstractDTO.getNeedBusinessMessage())) {
                activityData.put("businessMessageSourceType", cardAbstractDTO.getBusinessMessageSourceType());
                activityData.put("cardId", projectId);
                activityData.put("pageCode", TmPageName.PROJECT_CARD_NAME.getValue());
                activityData.put("tmTaskId", task.getTmTaskId());
                activityData.put("tenantId", task.getTenantId());
                backlogAbstractUtil.getAndSaveBusinessMessage(activityData);
            }
        }
        return map;
    }

    private Map setCheckSummaryForProjectCardAbstract(Map<String, Object> map, Task task, CardAbstractDTO cardAbstractDTO) {
        //默认未逾期，仅用于项目中控台
        map.put("overdue", false);

        String tmTaskId = (String) map.get("tmTaskId");
        long projectId = (long) map.get("projectId");

        TmTaskDefineResponseDTO themeMap = themeMapService.getTask(tmTaskId);
        if (themeMap == null || themeMap.getPages() == null) {
            return null;
        }

        Map pages = themeMap.getPages();
        TmActivityPageDTO projectCardPage = null;
        if (pages.containsKey(TmPageName.PROJECT_CARD_NAME.getValue())) {
            String json = JsonUtils.objectToString(pages.get(TmPageName.PROJECT_CARD_NAME.getValue()));
            projectCardPage = JsonUtils.jsonToObject(json, TmActivityPageDTO.class);
        } else {
            return null;
        }

        //xuxx 2022-11-01 所有的card也需要增加dataStates配置，如果同时存在，以dataStates里的为主
        if (CollectionUtils.isNotEmpty(projectCardPage.getDataStates()) && projectCardPage.getDataStates().size() > 0) {
            //默认先取第一个展示与uibot保持一致
            TmDataState dataState = projectCardPage.getDataStates().get(0);
            if (CollectionUtils.isNotEmpty(dataState.getSummaryFields())) {
                projectCardPage.setSummaryFields(dataState.getSummaryFields());
            }
        }
        //兼容以前的逻辑，重构时可考虑合并；
        if (CollectionUtils.isEmpty(projectCardPage.getSummaryFields())) {
            //目前只支持summaryFields
            return null;
        }
        boolean enableQueryApi = true;
        if(!cardAbstractDTO.isEnableQueryApi()){
            enableQueryApi = BooleanUtils.isNotFalse(projectCardPage.getEnableQueryApi());
        }
        Map<String, Object> cardAbstractMap = new HashMap<>();
        Map activityData = getActivityData(task);
        activityData.put("needHistoryInfo", cardAbstractDTO.getNeedHistoryInfo());
        if(enableQueryApi){
            BaseResultDTO<Map<String, Object>> actionResponse = aglieService.getProjectCardDataByProjectDataAbstract(tmTaskId, projectId, activityData);
            if (actionResponse == null || actionResponse.getResponse() == null) {
                return activityData;
            }
            cardAbstractMap = actionResponse.getResponse();
        }else {
            QueryWrapper<TaskWorkitemMessage> queryWrapper = new QueryWrapper<>();
            queryWrapper.select("summary","history_message","search_message");
            queryWrapper.eq("card_id",projectId);
            List<TaskWorkitemMessage> workitemMessageList = taskWorkitemMessageMapper.selectList(queryWrapper);
            if(CollectionUtils.isNotEmpty(workitemMessageList)){
                TaskWorkitemMessage taskWorkitemMessage = workitemMessageList.get(0);
                cardAbstractMap = Maps.newHashMapWithExpectedSize(3);
                cardAbstractMap.put("summaryLayoutStr",taskWorkitemMessage.getSummary());
                cardAbstractMap.put("historyMessage",taskWorkitemMessage.getHistoryMessage());
                cardAbstractMap.put("searchMessage",taskWorkitemMessage.getSearchMessage());
            }
        }
        if (MapUtil.isEmpty(cardAbstractMap)) {
            return activityData;
        }
        // 将 scheduleRefreshCardMessage 携带出该方法
        map.put("scheduleRefreshCardMessage", projectCardPage.getScheduleRefreshCardMessage());
        map.put("scheduleRefreshCardType", projectCardPage.getScheduleRefreshCardType());
        map.put("summaryLayout", cardAbstractMap.get("summaryLayoutStr"));
        map.put("historyMessage", cardAbstractMap.get("historyMessage"));
        map.put("searchMessage", cardAbstractMap.get("searchMessage"));
        map.put("projectMessage", cardAbstractMap.get("projectMessage"));

        //xuxx 2022-11-01 所有的card也需要增加dataStates配置，如果同时存在，以dataStates里的为主
        if (CollectionUtils.isNotEmpty(projectCardPage.getDataStates()) && projectCardPage.getDataStates().size() > 0) {
            //默认先取第一个展示与uibot保持一致
            TmDataState dataState = projectCardPage.getDataStates().get(0);
            if (!org.apache.commons.lang.StringUtils.isEmpty(dataState.getOverduePropertyName())) {
                projectCardPage.setOverduePropertyName(dataState.getOverduePropertyName());
            }
        }
        //兼容以前的逻辑，待旧配置迁移完后可考虑合并；
        //region PCC的项目逾期通过API的返回字段，修改卡片样式为逾期样式
        if (!StringUtils.isEmpty(projectCardPage.getOverduePropertyName())) {
            if (cardAbstractMap.containsKey("pageData")
                    && cardAbstractMap.get("pageData") != null
                    && cardAbstractMap.get("pageData") instanceof Map) {
                Map<String, Object> pageData = (Map<String, Object>) cardAbstractMap.get("pageData");
                if (MapUtils.isNotEmpty(pageData) && pageData.containsKey(projectCardPage.getOverduePropertyName())) {
                    Object overdue = pageData.get(projectCardPage.getOverduePropertyName());
                    map.put("overdue", Objects.equals(overdue, 1.0));
                }
            }
        }

        // 设置卡面呈现配置
        cardPresentConfigQryService.setCardPresentConfigs(map,TmPageName.PROJECT_CARD_NAME.getValue());

        return activityData;
        //endregion
    }

    /**
     * 获取项目卡本身的摘要信息，不获取其含有的任务摘要信息
     *
     * @param user
     * @param projectId
     * @return
     */
    public Map getProjectCardSelf(AuthoredUser user, long projectId) {

//        Task task = taskMapper.selectById(projectId);
//        if (task == null) {
        Task task = commonPtmTransformService.getTask(projectId);
//        }
        Map<String, Object> map = new HashMap<>();
        map.put("tmTaskId", task.getTmTaskId());
        map.put("projectId", projectId);

        setCheckSummaryForProjectCard(map, task);
        return map;

    }

    private void setCheckSummaryForProjectCard(Map<String, Object> map, Task task) {
        //默认未逾期，仅用于项目中控台
        map.put("overdue", false);

        String tmTaskId = (String) map.get("tmTaskId");
        long projectId = (long) map.get("projectId");

        TmTaskDefineResponseDTO themeMap = themeMapService.getTask(tmTaskId);
        if (themeMap == null || themeMap.getPages() == null) {
            return;
        }

        Map pages = themeMap.getPages();
        TmActivityPageDTO projectCardPage = null;
        if (pages.containsKey(TmPageName.PROJECT_CARD_NAME.getValue())) {
            String json = JsonUtils.objectToString(pages.get(TmPageName.PROJECT_CARD_NAME.getValue()));
            projectCardPage = JsonUtils.jsonToObject(json, TmActivityPageDTO.class);
        } else {
            return;
        }

        //xuxx 2022-11-01 所有的card也需要增加dataStates配置，如果同时存在，以dataStates里的为主
        if (CollectionUtils.isNotEmpty(projectCardPage.getDataStates()) && projectCardPage.getDataStates().size() > 0) {
            //默认先取第一个展示与uibot保持一致
            TmDataState dataState = projectCardPage.getDataStates().get(0);
            if (CollectionUtils.isNotEmpty(dataState.getSummaryFields())) {
                projectCardPage.setSummaryFields(dataState.getSummaryFields());
            }
        }
        //兼容以前的逻辑，待旧配置迁移完后可考虑合并；
        if (CollectionUtils.isEmpty(projectCardPage.getSummaryFields())) {
            //目前只支持summaryFields
            return;
        }

        Map activityData = getActivityData(task);

        BaseResultDTO<Map<String, Object>> actionResponse = aglieService.getProjectCardDataByProjectData(tmTaskId, projectId, activityData);
        if (actionResponse == null || actionResponse.getResponse() == null || !actionResponse.getResponse().containsKey("pageData")) {
            return;
        }

        map.put("summaryLayout", actionResponse.getResponse());

        //xuxx 2022-11-01 所有的card也需要增加dataStates配置，如果同时存在，以dataStates里的为主
        if (CollectionUtils.isNotEmpty(projectCardPage.getDataStates()) && projectCardPage.getDataStates().size() > 0) {
            //默认先取第一个展示与uibot保持一致
            TmDataState dataState = projectCardPage.getDataStates().get(0);
            if (!StringUtils.isEmpty(dataState.getOverduePropertyName())) {
                projectCardPage.setOverduePropertyName(dataState.getOverduePropertyName());
            }
        }
        //兼容以前的逻辑，待旧配置迁移完后可考虑合并；
        //region PCC的项目逾期通过API的返回字段，修改卡片样式为逾期样式
        if (!StringUtils.isEmpty(projectCardPage.getOverduePropertyName())) {
            Map<String, Object> response = actionResponse.getResponse();
            if (response.containsKey("pageData") && response.get("pageData") != null && response.get("pageData") instanceof Map) {
                Map<String, Object> pageData = (Map<String, Object>) response.get("pageData");
                if (MapUtils.isNotEmpty(pageData)) {
                    for (Map.Entry<String, Object> stringObjectEntry : pageData.entrySet()) {
                        if (stringObjectEntry.getValue() != null) {
                            Map<String, Object> firstValue = null;
                            if (stringObjectEntry.getValue() instanceof Map) {
                                firstValue = (Map<String, Object>) stringObjectEntry.getValue();
                            } else if (stringObjectEntry.getValue() instanceof List) {
                                List list = (List) stringObjectEntry.getValue();
                                if (CollectionUtils.isNotEmpty(list)) {
                                    firstValue = (Map<String, Object>) (list.get(0));
                                }
                            }

                            if (firstValue != null && firstValue.containsKey(projectCardPage.getOverduePropertyName())) {
                                Object overdue = firstValue.get(projectCardPage.getOverduePropertyName());
                                map.put("overdue", Objects.equals(overdue, 1));
                            }
                        }
                    }
                }
            }
        }
        //endregion
    }
}
