package com.digiwin.athena.atmc.common.util;

import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.atmc.core.meta.enums.km.TmTaskCategoryEnum;
import com.digiwin.athena.atmc.core.meta.enums.km.TmTaskPatternEnum;

/**
 * PatternCategoryUtil Description
 * pattern、category工具类
 *
 * @author majianfu
 * @date 2023/5/16
 * @since
 */
public final class PatternCategoryUtil {
    private PatternCategoryUtil() {
    }

    /**
     * 任务category是否为签核类型
     *
     * @param category 任务定义category
     * @return
     */
    public static boolean isApproval(String category) {
        return TmTaskCategoryEnum.APPROVAL.getValue().equals(category);
    }

    /**
     * 是否为报表pattern
     *
     * @param pattern
     * @return
     */
    public static boolean isReportPattern(String pattern) {
        return StrUtil.equals(TmTaskPatternEnum.STATEMENT.getPattern(), pattern);
    }

    /**
     * 是否为基础资料录入pattern
     *
     * @param pattern
     * @return
     */
    public static boolean isBaseDataPattern(String pattern) {
        return StrUtil.equals(TmTaskPatternEnum.BASE_DATA.getPattern(), pattern);
    }

    /**
     * 是否为手动发起项目category
     *
     * @param category
     * @return
     */
    public static boolean isStartProjectCategory(String category) {
        return StrUtil.equals(TmTaskCategoryEnum.START_PROJECT.getCategory(), category);
    }

}
