package com.digiwin.athena.atmc.common.util.engine;

import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.atmc.common.dao.*;
import com.digiwin.athena.atmc.infrastructure.mapper.biz.migration.BacklogMapper;

import java.util.Objects;

/**
 * @Author wuzq
 * @Date 2023/7/31 17:19
 * @Description: 获取引擎判断相关bean
 * @Version 1.0
 */
public class FlowEngineBeanUtils {
    private static BpmActivityWorkitemMapper bpmActivityWorkitemMapper;
    private static BacklogMapper backlogMapper;
    private static BpmActivityStepMapper bpmActivityStepMapper;
    private static BpmActivityMapper bpmActivityMapper;
    private static ActivityMapper activityMapper;

    private static TaskMapper taskMapper;
    private static BpmProcessMapper bpmProcessMapper;

    public static BpmActivityWorkitemMapper getBpmActivityWorkitemMapper() {
        if (Objects.isNull(bpmActivityWorkitemMapper)) {
            synchronized (FlowEngineBeanUtils.class) {
                if (Objects.isNull(bpmActivityWorkitemMapper)) {
                    bpmActivityWorkitemMapper = SpringUtil.getBean(BpmActivityWorkitemMapper.class);
                }
            }
        }
        return bpmActivityWorkitemMapper;
    }


    public static BacklogMapper getBacklogMapper() {
        if (Objects.isNull(backlogMapper)) {
            synchronized (FlowEngineBeanUtils.class) {
                if (Objects.isNull(backlogMapper)) {
                    backlogMapper = SpringUtil.getBean(BacklogMapper.class);
                }
            }
        }
        return backlogMapper;
    }

    public static BpmActivityStepMapper getBpmActivityStepMapper() {
        if (Objects.isNull(bpmActivityStepMapper)) {
            synchronized (FlowEngineBeanUtils.class) {
                if (Objects.isNull(bpmActivityStepMapper)) {
                    bpmActivityStepMapper = SpringUtil.getBean(BpmActivityStepMapper.class);
                }
            }
        }
        return bpmActivityStepMapper;
    }

    public static BpmActivityMapper getBpmActivityMapper() {
        if (Objects.isNull(bpmActivityMapper)) {
            synchronized (FlowEngineBeanUtils.class) {
                if (Objects.isNull(bpmActivityMapper)) {
                    bpmActivityMapper = SpringUtil.getBean(BpmActivityMapper.class);
                }
            }
        }
        return bpmActivityMapper;
    }

    public static ActivityMapper getActivityMapper() {
        if (Objects.isNull(activityMapper)) {
            synchronized (FlowEngineBeanUtils.class) {
                if (Objects.isNull(activityMapper)) {
                    activityMapper = SpringUtil.getBean(ActivityMapper.class);
                }
            }
        }
        return activityMapper;
    }

    public static TaskMapper getTaskMapper() {
        if (Objects.isNull(taskMapper)) {
            synchronized (FlowEngineBeanUtils.class) {
                if (Objects.isNull(taskMapper)) {
                    taskMapper = SpringUtil.getBean(TaskMapper.class);
                }
            }
        }
        return taskMapper;
    }

    public static BpmProcessMapper getBpmProcessMapper() {
        if (Objects.isNull(bpmProcessMapper)) {
            synchronized (FlowEngineBeanUtils.class) {
                if (Objects.isNull(bpmProcessMapper)) {
                    bpmProcessMapper = SpringUtil.getBean(BpmProcessMapper.class);
                }
            }
        }
        return bpmProcessMapper;
    }
}
