package com.digiwin.athena.atmc.common.bk.domain;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;

/**
 * TEProjectBKLackData Description
 *
 * @author majianfu
 * @date 2023/3/15
 * @since
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class TEProjectBKLackData {
    /**
     * 密码，必填
     */
    @NotBlank
    private String password;

    @NotEmpty
    private List<String> bkFields;

    @NotEmpty
    private List<TenantToken> tokens;

    @NotEmpty
    private List<TEProjectBKData> projects;

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    public static class TenantToken {
        private String tenantId;

        private String token;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class TEProjectBKData {
        private Long id;

        private Long projectCardId;

        private String tenantId;
    }
}
