package com.digiwin.athena.atmc.common.bk.parser.metadata.impl;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.common.bk.parser.core.Constant.Common;
import com.digiwin.athena.atmc.common.bk.parser.dto.metadata.IMetadataUnit;
import com.digiwin.athena.atmc.common.bk.parser.dto.metadata.TaskBkMetadata;
import com.digiwin.athena.atmc.common.bk.parser.metadata.AbstractBkMetadataParser;
import com.digiwin.athena.atmc.common.bk.parser.metadata.IBkMetadataParser;
import com.digiwin.athena.atmc.http.restful.thememap.ThemeMapService;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author zhangzhi@digiwin.com
 * @date 2021/11/22
 */
@Service("taskBkMetadataParser")
public class TaskBkMetadataParser extends AbstractBkMetadataParser implements IBkMetadataParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskBkMetadataParser.class);

    @Autowired
    private ThemeMapService themeMapService;

    @Override
    public IMetadataUnit parse(String queryCode, String queryType, AuthoredUser user) {
        JSONArray metaData = themeMapService.getTmTaskAndActivityBk(queryType,queryCode,user);
        /** NOTE 目前只按照数组中只存在一个bk进行处理，后续如果有多种业务场景，此处需要同步调整 */
        JSONObject metaObj = metaData.getJSONObject(0);
        return new TaskBkMetadata(constructMetadata(JsonUtils.jsonToObject(JsonUtils.objectToString(metaObj),JSONObject.class), Common.PROCESS_VAR));
    }
}
