package com.digiwin.athena.atmc.common.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.atmc.common.domain.TaskPanelActivityDTO;
import com.digiwin.athena.atmc.http.domain.Activity;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.List;
import java.util.Map;
@Component
public interface ActivityMapper extends BaseMapper<Activity> {

    List<Map<String,Object>> getTaskSlowestActivity(@Param("taskIds") List<Long> taskIds);


    List<Map<String,Object>> getTaskSlowestActivityByType(@Param("taskIds") List<Long> taskIds,@Param("type") String type);

    List<Map<String,Object>> getTaskExceptionActivity(@Param("taskIds") List<Long> taskIds);

    List<TaskPanelActivityDTO> getAllTaskActivity(@Param("taskId")Long taskId);

    List<Map<String,Object>> getAllActivityForCarousel(@Param("taskIds") List<Long> taskIds);

    /**
     * 获取指项目Id所有的异常或逾期任务
     * <br>此方法分别表示异常和逾期
     * <br>与 getTaskExceptionActivity 的差别是，getTaskExceptionActivity 中将逾期也当作异常
     * @param projectIds
     * @return
     */
    List<Map<String,Object>> getExceptionAndOverdueTask(@Param("projectIds") List<Long> projectIds);

    /**
     * 更新 data
     */
    void updateDataByProcessIdAndTmActivityId(@Param("processId") Long processId, @Param("activityDefineId")Long activityDefineId, @Param("data")String data);

    /**
     * 根据流程主键关闭所有关联的待办（任务卡）
     * @param bpmProcessSqlId
     * @return
     */
    int closeByBpmProcessSqlId(@Param("bpmProcessSqlId") long bpmProcessSqlId);

    List<Long> getPreActivityId(@Param("bpmProcessSqlId") long bpmProcessSqlId, @Param("currentActivitySql") long currentActivitySql);

    void closeActivity(@Param("currentActivitySql") long currentActivitySql);

    /**
     * 根据 bpm_process.id 和 activity_define.id 获取 activity
     * @param bpmProcessSqlId
     * @param activityDefineSqlId
     * @return
     */
    Activity getByProcessIdAndActivityDefineId(@Param("bpmProcessSqlId") long bpmProcessSqlId, @Param("activityDefineSqlId") long activityDefineSqlId);

    /**
     * 根据tmActivityId获取节点状态信息
     * @Author：SYQ
     * @Date：2021/8/5 9:26
     */
    List<TaskPanelActivityDTO> selectByTmActivityId(@Param("tmActivityId") String tmActivityId,@Param("tmTaskId") String tmTaskId,
                                                    @Param("compositionId") String compositionId,@Param("taskId") Long taskId);



    /**
     * 批量插入 仅适用于mysql
     *
     * @param entityList 实体列表
     * @return 影响行数
     */
    Integer insertBatchSomeColumn(Collection<Activity> entityList);

    /**
     * 按照复合条件查询任务
     *
     * @param bpmActivityId
     * @param tmTaskId
     * @param taskId
     * @return
     */
    List<TaskPanelActivityDTO> selectActivityAndTaskByBpmActivityId(@Param("bpmActivityId") String bpmActivityId,
                                                                    @Param("tmTaskId") String tmTaskId,
                                                                    @Param("taskId") Long taskId);

    Long queryById(@Param("id") Long id);

    List<Long> queryByIds(@Param("ids") List<Long> ids);
}
