package com.digiwin.athena.atmc.common.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.atmc.common.domain.BpmActivity;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.ActivityDataBO;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.springframework.stereotype.Component;

@Component
public interface BpmActivityMapper  extends BaseMapper<BpmActivity> {

    /**
     * 根据主待办 backlog 查询
     * @param taskId
     * @param tmActivityId
     * @return
     */
    List<ActivityDataBO> selectActivityDataByTaskId(@Param("taskId") long taskId, @Param("tmActivityId") String tmActivityId);

    ActivityDataBO selectActivityDataByBpmyActivityId(@Param("bpmActivityId") long bpmActivityId );

    BpmActivity selectByTmActivity(String processSerialNumber,String tmActivityId);

    void updateStateDataByPrimaryKey(Long id, String stateData);

    List<Integer> selectStateByProcessIdAndTmActivityId(@Param("processSerialNumber") String processSerialNumber,@Param("tmActivityId") String tmActivityId);

    /**
     * 根据流程实例id，查询bpm_activity_id列表
     *
     * @param processSerialNumber 流程实例id
     * @return pm_activity_id列表
     */
    List<Long> selectIdByProcessSerialNumber(@Param("processSerialNumber") String processSerialNumber);

    /**
     * 获取指定流程最后一个任务
     * @param processId
     * @return
     */
    @Select("select * from bpm_activity where bpm_process_id= #{processId} order by id desc limit 1")
    BpmActivity getLastActivityByProcessId(@Param("processId") Long processId);

    /**
     * 获取指定流程指定themeMap活动的第一笔数据
     * @param processId
     * @param tmActivityId
     * @return
     */
    @Select("select * from bpm_activity where bpm_process_id= #{processId} AND activity_id = #{tmActivityId} order by id limit 1")
    BpmActivity getFirstActivityByTmActivityId(@Param("processId") Long processId, @Param("tmActivityId") String tmActivityId);

    /**
     * 获取指定流程指定themeMap活动的最后一笔数据
     * @param processId
     * @param tmActivityId
     * @return
     */
//    @Select("select * from bpm_activity where bpm_process_id= #{processId} AND activity_id = #{tmActivityId} order by id desc limit 1")
    BpmActivity getLastByTmActivityId(@Param("processId") Long processId, @Param("tmActivityId") String tmActivityId);

    /**
     * 根据taskUid获取数据
     * @Author：SYQ
     * @Date：2021/7/22 9:26
     */
    BpmActivity getLastByTaskUid(@Param("processId") Long processId, @Param("tmActivityId") String tmActivityId,@Param("taskUid") String taskUid);

    /**
     *
     * @param backlogId
     * @return
     */
    List<BpmActivity> selectApprovalByBacklogId( @Param("backlogId") Long backlogId);


    List<Map> selectActivityDataByTaskIdAndTmActivityId(@Param("taskId") Long taskId, @Param("tmActivityIds")  List<String> tmActivityIds);

    /**
     * 更新
     * @param id
     */
    void updateDataById(@Param("id") Long id, @Param("data")String data);

    BpmActivity selectByBacklogId(@Param("backlogId") Long backlogId);

    BpmActivity selectByWorkItemId(@Param("workItemId") Long workItemId);

    BpmActivity selectFirstByProcessSerialNumber(@Param("tenantId") String tenantId, @Param("processSerialNumber") String processSerialNumber);

    List<BpmActivity> selectUnclosedByProcSerialNum(@Param("processSerialNumber") String processSerialNumber);

    /**
     * 根据originalBacklogId查找未关闭的虚拟关卡
     * @param originalBacklogId
     * @return
     */
    List<BpmActivity> selectVirtualByOriginalBacklogId(@Param("originalBacklogId") Long originalBacklogId);

    /**
     * 根据 bpmActivitySqlId 关闭虚拟关卡
     * @param bpmActivitySqlId
     * @return
     */
    int closeVirtualByBpmActivitySqlId(@Param("bpmActivitySqlId") Long bpmActivitySqlId);

    BpmActivity selectLastByBpmActivityOID(@Param("bpmProcessSqlId") Long bpmProcessSqlId, @Param("bpmActivityOID") String bpmActivityOID);

    /**
     * 根据 originalBacklogId 获取未结束的关卡
     * @param originalBacklogId
     * @return
     */
    List<Map> selectNoFinishedListByOriginBacklogId(@Param("originalBacklogId") Long originalBacklogId);

    /**
     * 根据 流程序列号、活动定义code，获取第一条未关闭的bpm activity data
     * @param processSerialNumber
     * @param activityId
     * @return
     */
    BpmActivity selectFirstUnClosedByProcessSerialNumberAndActivityId(@Param("processSerialNumber") String processSerialNumber, @Param("activityId") String activityId);

    /**
     * 更新活动状态
     * @param bpmActivitySqlId 活动主键
     * @param state  状态
     * @param closedTime  关闭时间
     * @param exception  是否异常
     * @return
     */
    int updateBpmActivityState(@Param("bpmActivitySqlId") Long bpmActivitySqlId, @Param("state") Integer state , @Param("closedTime") LocalDateTime closedTime,
                               @Param("exception") boolean exception);

    /**
     * 根据流程主键和 taskUid 获取任务
     * @param processSqlId
     * @param taskUid
     * @return
     */
    BpmActivity getByProcessSqlIdAndTaskUid(@Param("processSqlId") Long processSqlId, @Param("taskUid") String taskUid);

    /**
     * 任务引擎 不需要合并的项目路线节点下的数据
     * @Author：SYQ
     * @Date：2021/8/8 15:45
     */
    List<ActivityDataBO> selectTaskEngineTaskActivityData(@Param("tmActivityId") String tmActivityId, @Param("taskIdList") String[] taskIdList,
                                                          @Param("bpmActivityIdList") List bpmActivityIdList);

    /**
     * 根据 bpm_activity_workitem.id 获取 bpm_activity 的部分数据
     *   只返回部分数据：
     * @param workItemSqlId bpm_activity_workitem 的主键
     * @return id, engine_type, task_uid
     */
    BpmActivity getPartialByWorkitemSqlId(@Param("workItemSqlId") Long workItemSqlId);

    /**
     * 批量插入 仅适用于mysql
     *
     * @param entityList 实体列表
     * @return 影响行数
     */
    Integer insertBatchSomeColumn(Collection<BpmActivity> entityList);

    Long queryById(@Param("id") Long id);

    List<Long> queryByIds(@Param("ids") List<Long> ids);
}
