package com.digiwin.athena.atmc.common.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.atmc.common.domain.BpmActivityStep;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.List;

@Component
public interface BpmActivityStepMapper extends BaseMapper<BpmActivityStep> {
    /**
     * 根据任务id来获取
     * @return
     */
    BpmActivityStep selectByWorkitemId(Long workItemId);

    /**
     * 更新
     * @param id
     */
    void updateDataByPrimaryKey(@Param("id") Long id, @Param("data")String data);
    /**
     *  根据BPM中的关卡ID查找关卡
     * @param activityId       bpm_activitiy.id
     * @param bpmActivityId     BPM中的关卡ID
     * @return
     */
    BpmActivityStep selectByBpmActivityId(Long activityId,String bpmActivityId);

    /**
     * 根据活动ID，查找所有的关卡数据
     * @param activityId      bpm_activitiy.id
     * @return
     */
    List<BpmActivityStep> listByActivityId(Long activityId);

    /**
     *  根据BPM中的关卡OID查找关卡
     * @param bpmProcessSqlId       bpm_process.id
     * @param bpmActivityOID     BPM中的关卡OID
     * @return
     */
    BpmActivityStep selectByBpmActivityOID(Long bpmProcessSqlId,String bpmActivityOID);

    @Update("update bpm_activity_step\n" +
            "set closed_time = now(), state = 3, sub_state = 10 \n" +
            "where closed_time is null and activity_id = #{bpmActivitySqlId}  ")
    int completeByBpmActivitySqlId(@Param("bpmActivitySqlId") Long bpmActivitySqlId);

    @Select("select * from bpm_activity_step where activity_id = #{bpmActivitySqlId} order by id desc limit 1")
    BpmActivityStep selectLastByBpmActivitySqlId(@Param("bpmActivitySqlId") Long bpmActivitySqlId);

    @Select("select * from bpm_activity_step where activity_id = #{bpmActivitySqlId} AND bpm_activity_id= #{bpmActivityId} order by id limit 1")
    BpmActivityStep selectFirstByBpmActivityId(@Param("bpmActivitySqlId") Long bpmActivitySqlId, @Param("bpmActivityId") String bpmActivityId);

    /**
     * 根据ThemeMap获取-->签核<--列表
     * @return
     */
    List<BpmActivityStep> selectApprovalByTmActivityId(@Param("tenantId") String tenantId, @Param("processSerialNumber") String processSerialNumber, @Param("tmActivityId") String tmActivityId);

    /**
     * 方案历程
     * @param backlogId
     * @return
     */
    List<BpmActivityStep> selectApprovalByBacklogId( @Param("backlogId") Long backlogId);

    BpmActivityStep selectFirstByActivitySqlId(@Param("activitySqlId") Long activitySqlId);

    /**
     *  根据BPM中的关卡OID查找关卡
     * @param bpmProcessId       bpmProcessId
     * @param bpmActivityOID     BPM中的关卡OID
     * @return
     */
    BpmActivityStep selectAnyByBpmActivityOID(Long bpmProcessId,String bpmActivityOID);

    /**
     * 获取未未完成的最后一个关卡，排除虚拟关卡
     * @param bpmActivitySqlId
     * @return
     */
    BpmActivityStep selectNoCompletedByBpmActivitySqlId(@Param("bpmActivitySqlId") Long bpmActivitySqlId);

    /**
     * 获取预测关卡Id列表
     * @param bpmActivitySqlId
     * @return
     */
    @Select("select id from bpm_activity_step where state=-1 AND activity_id= #{bpmActivitySqlId} ; ")
    List<Long> selectForecastStepIdByBpmActivityId(@Param("bpmActivitySqlId") Long bpmActivitySqlId);

    BpmActivityStep selectByBacklogId(@Param("backlogId") Long backlogId);

    /**
     * 根据ThemeMap获取-->签核<--列表
     * @return
     */
    List<BpmActivityStep> selectApprovalByBpmActivitySqlId(@Param("bpmActivitySqlId") Long bpmActivitySqlId);

    /**
     * 根据活动ID，查找非预测关卡数量
     * @param activityId      bpm_activitiy.id
     * @return
     */
    int countByActivityId(Long activityId);

    /**
     * 根据 合并ID 查找未完成的数量
     * @param groupId
     * @return
     */
    int countNoFinishedByBpmWorkitemGroupId(Long groupId);

    /**
     * 根据流程主键关闭所有关联的step
     * @param bpmProcessSqlId
     * @return
     */
    int closeByBpmProcessSqlId(@Param("bpmProcessSqlId") long bpmProcessSqlId);

    /**
     * 批量插入 仅适用于mysql
     *
     * @param entityList 实体列表
     * @return 影响行数
     */
    Integer insertBatchSomeColumn(Collection<BpmActivityStep> entityList);

    Long queryById(@Param("id") Long id);

    List<Long> queryByIds(@Param("ids") List<Long> ids);
}