package com.digiwin.athena.atmc.common.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.BacklogBO;
import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.BacklogStateBO;
import com.digiwin.athena.atmc.infrastructure.pojo.po.migration.BpmActivityWorkitem;
import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.ActivityDataBO;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Component
public interface BpmActivityWorkitemMapper extends BaseMapper<BpmActivityWorkitem> {

//    @Update("update bpm_activity_workitem \n" +
//            "inner join bpm_activity_step on bpm_activity_workitem.activity_step_id = bpm_activity_step.id \n" +
//            "set bpm_activity_workitem.state = 3, bpm_activity_workitem.closed_time = now() \n" +
//            "where bpm_activity_workitem.closed_time is null AND \n" +
//            "bpm_activity_step.activity_id = #{activityId} and bpm_activity_step.bpm_activity_id = #{bpmActivityId} ")
//    int completeByBpmActivityId(@Param("activityId") Long activityId, @Param("bpmActivityId") String bpmActivityId);

    @Update("update bpm_activity_workitem\n" +
            "inner join bpm_activity_step on bpm_activity_workitem.activity_step_id=bpm_activity_step.id\n" +
            "set bpm_activity_workitem.closed_time = now(), bpm_activity_workitem.state = 3, bpm_activity_workitem.sub_state = 10 \n" +
            "where bpm_activity_workitem.closed_time is null and bpm_activity_step.activity_id= #{bpmActivitySqlId} ")
    int completeByBpmActivitySqlId(@Param("bpmActivitySqlId") Long bpmActivitySqlId);

    /**
     * 根据ThemeMap获取-->签核<--列表
     * @return
     */
    List<BpmActivityWorkitem> selectApprovalByTmActivityId(@Param("tenantId") String tenantId, @Param("processSerialNumber") String processSerialNumber, @Param("tmActivityId") String tmActivityId);

    /**
     * 方案历程
     * @param backlogId
     * @return
     */
    List<BpmActivityWorkitem> selectApprovalByBacklogId( @Param("backlogId") Long backlogId);

    BpmActivityWorkitem selectFirstByStepSqlId(@Param("stepSqlId") Long stepSqlId);

//    BpmActivityWorkitem selectByWorkitemId(@Param("stepSqlId") Long stepSqlId, @Param("workitemId") String workitemId);

    List<Map> selectByBacklogId(Long backlogId);

    /**
     * 根据 bpmStep 的主键，查找所有 workitem 的主键列表
     * @param bpmStepSqlId
     * @return
     */
    @Select("select id from bpm_activity_workitem where activity_step_id= #{bpmStepSqlId} ;")
    List<Long> selectWorkitemIdByStepSqlId(@Param("bpmStepSqlId") Long bpmStepSqlId);

    List<BacklogStateBO> selectWorkItemState(@Param("workItemIdList") List<Long> workItemIdList);

    /**
     * 根据 bpm_activity.id 查询所有 workitem
     * @param bpmActivitySqlId
     * @return
     */
    List<BpmActivityWorkitem> selectByBpmActivitySqlId(@Param("bpmActivitySqlId") Long bpmActivitySqlId);

    int selectUnreadCount(@Param("userId") String userId, @Param("tenantId") String tenantId);

    LocalDateTime selectLastModifyDate(@Param("userId") String userId, @Param("tenantId") String tenantId);

    /**
     * 根据 bpm_activity_step.id 查找所有 bpmActivityWorkitem
     * @param stepSqlId
     * @return
     */
    List<BpmActivityWorkitem> selectAllByStepSqlId(@Param("stepSqlId") Long stepSqlId);

//    /**
//     * 根据 bpm_activity_step.id 查找所有逾时的 bpmActivityWorkitem
//     * @param stepSqlId
//     * @return
//     */
//    List<BpmActivityWorkitem> selectOverdueByStepSqlId(@Param("stepSqlId") Long stepSqlId);
//
//    /**
//     * 根据 bpm_activity_step.id 查找所有 辅助执行人的 bpmActivityWorkitem
//     * @param stepSqlId
//     * @return
//     */
//    List<BpmActivityWorkitem> selectAssistByStepSqlId(@Param("stepSqlId") Long stepSqlId);

    /**
     * 根据 bpm_activity_step.id 查找所有 辅助执行人的及逾时的任务卡 bpmActivityWorkitem
     * @param stepSqlId
     * @return
     */
    List<BpmActivityWorkitem> selectSpecialByStepSqlId(@Param("stepSqlId") Long stepSqlId);

    /**
     * 根据 bpm_activity_step.id 查找所有 不包含逾时的 bpmActivityWorkitem
     * @param stepSqlId
     * @return
     */
    List<BpmActivityWorkitem> selectExcludeOverdueByStepSqlId(@Param("stepSqlId") Long stepSqlId);

    /**
     * 根据任务引擎的id来获取关卡最后一个提交人信息
     * @param taskUid
     * @return
     */
    BpmActivityWorkitem selectLastSubmitWorkItem(@Param("taskUid")String taskUid);

    /**
     * 根据tmActivityId获取任务列表
     * @Author：SYQ
     * @Date：2021/8/9 18:36
     */
    List<BacklogBO> selectWorkitemByTmActivityId(@Param("tmActivityIdList") List<String> tmActivityIdList,
                                                 @Param("tenantId") String tenantId,
                                                 @Param("performerId") String performerId);

    /**
     * 更新签核状态
     * @param workitemSqlId
     * @return
     */
    int updateApprovalStateById(@Param("workitemSqlId") long workitemSqlId, @Param("approvalState") String approvalState);

    /**
     * 更新actionId
     * @param workitemSqlId
     * @return
     */
    int clearActionIdById(@Param("workitemSqlId") long workitemSqlId);

    /**
     * 兼容 backlog,最迟迭代20可以去除
     * 根据 backlog.id 更新签核状态
     * @param backlogSqlId
     * @return
     */
    int updateApprovalStateByBacklogId(@Param("backlogSqlId") long backlogSqlId, @Param("approvalState") String approvalState);

    /**
     * 兼容 backlog,最迟迭代20可以去除
     * 根据 backlog.id 更新actionId
     * @param backlogSqlId
     * @return
     */
    int clearActionIdByBacklogId(@Param("backlogSqlId") long backlogSqlId);

    /**
     * 根据ThemeMap获取-->签核<--列表
     * @return
     */
    List<BpmActivityWorkitem> selectApprovalByBpmActivitySqlId(@Param("bpmActivitySqlId") Long bpmActivitySqlId);

    /**
     * 根据 bpm_activity_step.id 查找所有 不包含逾时、辅助执行者的的 bpmActivityWorkitem
     * @param stepSqlId
     * @return
     */
    List<BpmActivityWorkitem> selectNormalByStepSqlId(@Param("stepSqlId") Long stepSqlId);

    BpmActivityWorkitem selectMainWorkitem(String tenantId, String performerId,String tmTaskId, String tmActivityId, LocalDateTime endTime, String businessUnit);

    List<ActivityDataBO> getActivityDataByGroudId(Long groupId);

    List<Map> getDebuggerByGroupId(Long groupId);

    /**
     * 获取 指定合并ID的任何一个未 填写 actionId的 工作项的Id
     * @param groupId
     * @return id
     */
    BpmActivityWorkitem selectOneActionIdIsEmptyByGroupId(Long groupId);

    /**
     * 获取指定 bpm_activity_workitem.id 的子任务数量
     * @param workitemId
     * @return 如果为0表示未合并，否则表示合并
     */
    int selectChildCount(Long workitemId);

    /**
     * 根据流程主键，查找所有未关闭的 BpmActivityWorkitem ,获取的是部分字段
     * @param bpmProcessSqlId
     * @return id, activity_step_id, group_id
     */
    List<BpmActivityWorkitem> selectPartialByProcessSqlId(Long bpmProcessSqlId);

    /**
     * 更新重要性
     * @param id
     * @param importance
     * @param importanceSource
     * @return
     */
    int updateImportance(@Param("id") Long id, @Param("importance")Integer importance, @Param("importanceSource") String importanceSource);

    /**
     * 批量插入 仅适用于mysql
     *
     * @param entityList 实体列表
     * @return 影响行数
     */
    Integer insertBatchSomeColumn(Collection<BpmActivityWorkitem> entityList);

    /**
     * 根据 workitem.id 查找部分数据
     * @param workitemId
     * @return id,group_id,activity_step_id
     */
    BpmActivityWorkitem selectPartialById(Long workitemId);

    List<Map> queryTask(@Param(Constants.COLUMN_MAP)Map<String,Object> paramMap);

    /**
     * 查询签核历程相关的签核任务数据
     * @param paramMap
     * @return
     */
    List<Map> queryApprovalTask(@Param(Constants.COLUMN_MAP)Map<String,Object> paramMap);

    /**
     * 获取 指定workitemID的退回重签信息
     * @param workitemId
     * @return id
     */
    BpmActivityWorkitem selectReapprovalInfoById(Long workitemId);


    List<Map<String,Object>> selectByProcessIds(@Param("bpmProcessIds") Set<Long> bpmProcessIds);

    /**
     * 根据租户id查询任务卡
     * @Author：SYQ
     * @Date：2022/4/6 16:08
     */
    List<Map<String,Object>> selectWorkitemByParam(@Param(Constants.COLUMN_MAP) Map<String,Object> paramMap);

    /**
     * 根据id查询数据
     * @Author：SYQ
     * @Date：2022/5/9 18:16
     */
    List<Map<String,Object>> selectDataByWorkitemIds(@Param("workitemIdList") Set<String> workitemIdList);

    /**
     * 根据待办项ID 查询待办项名称（兼容PTM + 非PTM任务）
     *
     * @param workItemIdList
     * @return
     */
    List<Map<String, String>> queryNameById(@Param("idList") List<String> workItemIdList);

    /**
     * 根据待办项id 查询主项目id
     *
     * @param workItemId
     * @return
     */
    Map selectMainProjectIdByWorkItemId(@Param("workItemId") Long workItemId);


    /**
     * 根据bpm_activity.id查询未完成的主任务卡
     * @Author：SYQ
     * @Date：2022/7/26 17:10
     */
    List<Long> selectMainWorkitemByActivityId(@Param("bpmActivitySqlId") Long bpmActivitySqlId);

    Long queryById(@Param("id") Long id);

    List<Long> queryByIds(@Param("ids") List<Long> ids);
}
