package com.digiwin.athena.atmc.common.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.atmc.common.domain.email.ActivityEmail;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public interface EmailMapper extends BaseMapper<ActivityEmail> {

    /**
     * 根据tenantId查询租户下的任务的邮件模板
     */
    List<ActivityEmail> selectTemplates(String tenantId, Integer state, Integer type, String activityId, String langName);

    /**
     * 根据tenantId查询租户下的项目邮件模板
     */
    List<ActivityEmail> selectProjectTemplates(String tenantId, Integer state, Integer type, String taskId, String langName);

    /**
     * 根据tenantId查询租户下的任务的邮件模板
     */
    List<ActivityEmail> selectTemplateList(String tenantId, Integer state, Integer type, String taskId, String activityId, String langName);

    /**
     * 根据emailId查询邮件模板详情
     */
    ActivityEmail selectTemplateByEmailId(Long emailId);

    /**
     * 根据emailId查询邮件模板详情
     */
    ActivityEmail selectTemplateByEmailIdAndTenantId(Long emailId, String tenantId);

    /**
     * 根据tenantId查询租户下的任务的邮件模板
     */
    Integer selectTemplatesNum(String tenantId, Integer state, String activityId);

}
