package com.digiwin.athena.atmc.common.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.atmc.common.domain.task.TaskExtendDTO;
import com.digiwin.athena.atmc.common.domain.task.TaskListReqDTO;
import com.digiwin.athena.atmc.common.domain.task.TaskListRespDTO;
import com.digiwin.athena.atmc.common.domain.QueryTaskVO;
import com.digiwin.athena.atmc.http.domain.Task;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Update;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@Component
public interface TaskMapper extends BaseMapper<Task> {

    int clearAllData();

    /**
     * 根据租户清除数据
     * @param tenantId
     * @return
     */
    int  clearAllDataByTenantId(@Param("tenantId") String tenantId);

    int updateImportance(@Param("record") Task record);

    List<Map<String,Object>> selectCurrentUserTarget(@Param("userId") String userId,@Param("tenantId") String tenantId );


    /**
     * 移动端获取 项目目标
     * @param userId
     * @param tenantId
     * @param type
     * @return
     */
    List<Map<String,Object>> selectCurrentUserTargetByType(@Param("userId") String userId,@Param("tenantId") String tenantId,@Param("type") String type );


    List<Map<String,Object>> selectCurrentUserTargetByBusinessUnit(@Param("userId") String userId,@Param("tenantId") String tenantId ,@Param("businessUnit") String businessUnit );

    List<TaskExtendDTO> selectCurrentUserByTargetAndBusinessUnit(@Param("userId") String userId, @Param("tenantId") String tenantId, @Param("businessUnit") String businessUnit, @Param("targetIds") List<String> targetIds );

    /**
     * 移动端获取数据
     * @param userId
     * @param tenantId
     * @param businessUnit
     * @param targetIds
     * @param type
     * @return
     */
    List<TaskExtendDTO> selectCurrentUserByTargetAndBusinessUnitAndType(@Param("userId") String userId, @Param("tenantId") String tenantId,@Param("businessUnit") String businessUnit, @Param("targetIds") List<String> targetIds , @Param("type") String type );

    int updateSourceIdAndCount(@Param("record") Task record);

    int updateEmergency(@Param("taskId") long taskId,@Param("emergency") int emergency);

    int updateModifyDate(@Param("taskId") long taskId);
    /**
     * 根据targetIds查询异常任务总数
     * @param targetId task.target_id
     * @return
     */
    int countExceptionTask(@Param("targetId") String targetId, @Param("personInCharge") String personInCharge, @Param("tenantId") String tenantId);
//
//    /**
//     * 根据taskId查询任务是否异常
//     * @param taskId task.id
//     * @return
//     */
//    String isExceptionTask(@Param("taskId") String taskId);

    /**
     * 根据条件查询任务列表
     * @param reqDTO
     * @return
     */
    List<TaskListRespDTO> getTaskListByParam(TaskListReqDTO reqDTO);

    /**
     * 查询用于可视化面板的任务
     * @param taskId
     * @return
     */
    TaskExtendDTO selectTaskPanelByPrimaryKey(Long taskId, String tenantId);

    int updateByProcess(Task task);

    /**
     * 可视化面板-根据主任务Id获取子任务列表
     * @param mainTaskId
     * @return
     */
    List<TaskExtendDTO> selectSubTaskPanelByMainTaskId(long mainTaskId);

    int updateEmergencyByPrimaryKey(long taskId);

    int updateHideByPrimaryKey(long taskId);

    List<Task> getTasksByTenantId(String tenantId);

    /**
     * 查询任务
     * @param parameter
     * @return
     */
    List<QueryTaskVO> queryTask(Map<String,Object> parameter);

    QueryTaskVO operatingCompletionRate(Map<String,Object> parameter);


    Map<String,Object> mobileHomePageCarousel(Map<String,Object> parameter);


    Map<String,Object> mobileHomePageProjectClassify(Map<String,Object> parameter);

    List<Map<String,Object>> mobileHomePageCarouselTask(@Param("tenantId") String tenantId, @Param("personInCharge") String personInCharge);

    List<Map<String,Object>> selectCurrentUserTargetForMobile(@Param("userId") String userId,@Param("tenantId") String tenantId
            ,@Param("targetIds") List<String> targetIds
            , @Param("exception") Boolean exception
            , @Param("importance") Boolean importance
            , @Param("emergency") Boolean emergency
            , @Param("other") Boolean other);

    public Map<String,Object> getMainTaskProcess(@Param("mainTaskId") Long mainTaskId);

    /**
     * 已读次数增1
     * @param taskId
     * @return
     */
    @Update("update task set read_count = read_count + 1 where id = #{taskId} or main_task_id = #{taskId}")
    int increaseReadCount(@Param("taskId") Long taskId);

    List<TaskExtendDTO> selectProjectByUser(@Param("userIds") List<String> userIds, @Param("tenantId") String tenantId);
    TaskExtendDTO selectProjectById(@Param("taskId") Long taskId);
    LocalDateTime selectMainTaskLastModifyDate(@Param("userId") String userId, @Param("tenantId") String tenantId);
    Task selectByProcessSerialNumber(@Param("tenantId") String tenantId, @Param("processSerialNumber") String processSerialNumber);

    /**
     * 批量更新eoc_code、eoc_name、eoc_type等信息
     *
     * @param toUpdateTaskList
     * @return
     */
    int batchUpdateEoc(@Param("toUpdateTaskList") List<Task> toUpdateTaskList);

    List<TaskExtendDTO> selectSubTaskPanelByBatchMainTaskId(@Param("mainTaskIds") List<Long> mainTaskIds);

    List<Map> getDebuggerByProjectSqlId(Long projectSqlId);

    Task getTaskByBacklogId(@Param("backlogId") Long backlogId);

    /**
     * 获取任务的变更数据
     * @param projectId
     * @return
     */
    List<Map> getChangedData(@Param("projectId") Long projectId);

    /**
     * 根据taskId获取项目卡信息
     * @Author：SYQ
     * @Date：2021/4/26 17:02
     */
    TaskExtendDTO getProjectByTaskId(@Param("taskId") Long taskId);

    /**
     * 获取当前登录用户、租户下未关闭且未读的主项目数量
     *
     * @param userId
     * @param tenantId
     * @return
     */
    int selectUnreadCount(@Param("userId") String userId, @Param("tenantId") String tenantId);

    /**
     * 根据workItemId查询项目详情信息
     *
     * @param workItemId
     * @return
     */
    Map getTaskInfoByWorkItemId(@Param("workItemId") Long workItemId);

    /**
     * 根据项目id获取项目详情
     *
     * @param taskId
     * @return
     */
    Map getTaskInfoById(@Param("taskId") Long taskId);

    /**
     * 根据 bpm_activity.id 查找其所属的主项目
     *      该查询只返回部分字段，具体请查看SQL
     * @param bpmActivitySqlId
     * @return id, person_in_charge, tm_task_id, composition_id
     */
    Task getPartialMainProjectByBpmActivitySqlId(@Param("bpmActivitySqlId") Long bpmActivitySqlId);

    /**
     * 根据 task.id 获取部分内容
     * @param taskId
     * @return id, person_in_charge, tm_task_id, composition_id
     */
    Task selectPartialById(@Param("taskId") Long taskId);

    /**
     * 根据 bpm_activity_workitem.id 获取部分内容
     * @param workItemSqlId
     * @return id, person_in_charge, tm_task_id, composition_id
     */
    Task selectPartialByWorkitemSqlId(@Param("workItemSqlId") Long workItemSqlId);

    /**
     * 同步修改主项目、子项目的名称、开始日期、截止日期
     *
     * @param task
     * @return
     */
    int updateAllTaskNameAndTime(@Param("task") Task task);

    /**
     * 批量插入 仅适用于mysql
     *
     * @param entityList 实体列表
     * @return 影响行数
     */
    Integer insertBatchSomeColumn(Collection<Task> entityList);

    int closeProjectByProcessSerialNumber(String tenantId, Collection<String> processSerialNumbers);

    List<TaskExtendDTO> selectProjectByTaskId(@Param("idArr") List<Long> idArr, @Param("tenantId") String tenantId);

    /**
     * 将项目标记为已过期 expired=1
     *
     * @param projectCodeList
     */
    int markTaskExpired(@Param("tenantId") String tenantId, @Param("projectCodeList") List<String> projectCodeList);

    /**
     * 将项目标记为已过期 expired=1
     *
     * @param projectCodeList
     */
    int markTaskNoExpired(@Param("tenantId") String tenantId, @Param("projectCodeList") List<String> projectCodeList);

    Long queryById(@Param("id") Long id);

    List<Long> queryByIds(@Param("ids") List<Long> ids);
}
