package com.digiwin.athena.atmc.common.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.atmc.common.domain.ProjectSearch;
import com.digiwin.athena.atmc.common.domain.TaskWorkitemMessage;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author：SYQ
 * @date：2021/12/31
 */
@Component
public interface TaskWorkitemMessageMapper extends BaseMapper<TaskWorkitemMessage> {

    /**
     * 根据查询条件获取项目卡id
     * @Author：SYQ
     * @Date：2022/8/17 13:28
     */
    List<ProjectSearch> findProjectCardIdByParam(@Param("queryParam") String queryParam, @Param("tenantId") String tenantId,
                                                 @Param("personInCharges") List<String> personInCharges);
    /**
     * 根据cardId查询项目卡id
     * @Author：SYQ
     * @Date：2022/9/13 17:24
     */
    List<ProjectSearch> findProjectCardIdByCardIds(@Param("queryParam") String queryParam, @Param("tenantId") String tenantId,
                                         @Param("cardIds") List<Long> cardIds);

    /**
     * 新增or更新
     *
     * @param taskWorkitemMessage
     * @return
     */
    Integer insertOrUpdateMessage(TaskWorkitemMessage taskWorkitemMessage);

    /**
     * 根据业务数据查询任务卡id
     * @Author：SYQ
     * @Date：2023/1/10 10:47
     */
    List<Long> selectCardIdByParam(@Param("queryParam") String queryParam,@Param("tenantId") String tenantId);

    /**
     * 根据关键词、用户id列表查询项目卡id列表
     *
     * @param tenantId    租户id
     * @param userIds     用户id列表
     * @param searchTerms 关键词列表
     * @return
     */
    List<Long> findFlowEngineProjectCardIdByTerms(@Param("tenantId") String tenantId, @Param("userIds") List<String> userIds,
                                                  @Param("searchTerms") List<String> searchTerms,
                                                  @Param("projectCardIds") List<Long> projectCardIds,
                                                  @Param("matchUser") boolean matchUser);

    /**
     * 根据关键词、用户id列表查询任务卡id列表
     *
     * @param tenantId    租户id
     * @param userIds     用户id列表
     * @param searchTerms 关键词列表
     * @return
     */
    List<Long> findFlowEngineBacklogCardIdByTerms(@Param("tenantId") String tenantId,
                                                  @Param("userIds") List<String> userIds,
                                                  @Param("searchTerms") List<String> searchTerms,
                                                  @Param("matchUser") boolean matchUser);

    void batchUpdate(@Param("list") List<TaskWorkitemMessage> list);
}
