package com.digiwin.athena.atmc.common.dao.route;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.atmc.common.domain.route.RouteDetail;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.springframework.stereotype.Component;

/**
 * @author：SYQ
 * @date：2021/7/28
 */
@Component
public interface RouteDetailMapper extends BaseMapper<RouteDetail> {
    /**
     * 根据taskUid获取任务实例路线数据
     * @param taskUid
     * @return
     */
    @Select("select id,bpm_activity_id,task_uid,pre_task_uid,tm_activity_id,tm_activity_name," +
            "input_describe,forecast_activity,pass,route_id,tenant_id,task_id,create_date,modify_date " +
            "from route_detail where task_uid = #{taskUid} and task_id = ${taskId}")
    RouteDetail getRouteDetailByTaskUid(@Param("taskUid") String taskUid,@Param("taskId") Long taskId);


    /**
     * 根据pass和routeId获取任务实例路线数据
     * @param pass
     * @param routeId
     * @return
     */
    @Select("select id,bpm_activity_id,task_uid,pre_task_uid,tm_activity_id,tm_activity_name," +
            "input_describe,forecast_activity,pass,route_id,tenant_id,task_id,create_date,modify_date " +
            "from route_detail where pass = #{pass} and route_id = ${routeId}")
    RouteDetail getRouteDetailByPassAndRouteId(@Param("pass") String pass,@Param("routeId") Long routeId);
    
}
