package com.digiwin.athena.atmc.common.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.atmc.http.domain.BaseEntity;
import com.digiwin.athena.atmc.http.domain.bpm.TmRelatedUserDTO;
import com.digiwin.athena.atmc.http.restful.thememap.model.TmActivityExpectedDurationDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Accessors(chain = true)
@TableName(autoResultMap = true)
public class ActivityDefine   extends BaseEntity<ActivityDefine> {
    @TableId()
    private Long id;

    private String tmTaskId;

    private String tmActivityId;

    private String tmActivityName;

    private Integer tmSequence;

    private String tmExecuteDurationType;

    private Integer tmExecuteDurationValue;

    @JsonIgnore
    @TableField(exist = false)
    private TmActivityExpectedDurationDTO expectedDuration;

    private Boolean tmExecuteType;

    /**
     * 里程碑
     */
    private Boolean tmMilestone;

    private String tmPattern;
    private String tmCategory;

    /**
     * 活动详情是否显示流程图
     */
    private Boolean tmShowFlow;

    /**
     * 动态任务的id,参与项目卡合并计算
     */
    private String compositionId;

    /**
     * 任务是否合并
     */
    private boolean merge;

    /**
     * 缓存逾期提醒设置，
     */
    private String overdueRules;

    @JsonIgnore
    @TableField(exist = false)
    private TmRelatedUserDTO relatedUsers;

    @TableField(exist = false)
    private Long taskId;

}