package com.digiwin.athena.atmc.common.domain;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.atmc.infrastructure.utils.MySqlJsonArrayHandler;
import com.digiwin.athena.atmc.http.domain.BaseEntity;
import com.digiwin.athena.atmc.http.handler.MySqlJsonHandler;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import java.time.LocalDateTime;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Accessors(chain = true)
@TableName(autoResultMap = true)
public class BpmActivityStep  extends BaseEntity<BpmActivityStep> {
    @TableId()
    private Long id;

    /**
     * 所属活动的id，bmp_activiti.id
     */
    private Long activityId;

    private LocalDateTime createTime;

    private LocalDateTime closedTime;

    private String tenantId;

    private String bpmnType;

    private String bpmActivityId;

    private String bpmActivityName;
    @TableField(typeHandler = MySqlJsonHandler.class)
    private JSONObject bpmSignReason;

    private Integer state;
    @TableField(typeHandler = MySqlJsonArrayHandler.class)
    private JSONArray performerId;
    @TableField(typeHandler = MySqlJsonArrayHandler.class)
    private JSONArray workitemList;
    @TableField(typeHandler = MySqlJsonHandler.class)
    private JSONObject data;

    private LocalDateTime rowCreateTime;

    /**
     * 表示执行的动作ID
     * -- 2021-08-11 迭代18，zhujg,废弃，使用 bpm_activity_workitem.actionId
     */
    @Deprecated
    @TableField(updateStrategy = FieldStrategy.IGNORED )
    private String actionId;

    /**
     * bpm中表示step的唯一Key
     * 目前允许为空
     */
    private String bpmActivityOid;

    /**
     * 签核类型，1-signOr-或签，2-signAnd-会签,3-single-单一签核
     */
    private Integer signType = 1;

    /**
     * 签核前后通知
     */
    @TableField(typeHandler = MySqlJsonHandler.class)
    private JSONObject informer;

    /**
     * 0	未開始
     * 0	進行中
     * 0	暫停
     * 10	正常完成
     * 20	終止項目而關閉
     * 50	往前加簽而關閉
     * 60	退回重辦而關閉
     * 70	取回重辦而關閉
     * 80	強制終止
     * 90	項目被撤銷而關閉
     * 100	其他任務已處理完成而關閉
     * 200	退回重辦而關閉
     */
    private Integer subState;

    private String tenantName;

    /**
     * 重要状态
     */
    private Integer importantState;
}
