package com.digiwin.athena.atmc.common.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.atmc.infrastructure.utils.MySqlJsonArrayHandler;
import com.digiwin.athena.atmc.http.domain.BaseEntity;
import com.digiwin.athena.atmc.http.handler.MySqlJsonHandler;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import java.io.Serializable;
import java.time.LocalDateTime;
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Accessors(chain = true)
@TableName(autoResultMap = true)
public class BpmProcess  extends BaseEntity<BpmProcess> implements Serializable {
    /**
     *
     */
    private static final long serialVersionUID = -7902109667008057279L;

    @TableId()
    private Long id;

    private Long taskId;

    private String requesterId;

    private String processId;

    private String processSerialNumber;

    private String mainProcessSerialNumber;

    private String processName;

    private String subject;

    private LocalDateTime createTime;

    private Integer state;

    private LocalDateTime closedTime;

    private String tmTaskId;

    private LocalDateTime dueDate;

    private String personInCharge;

    private String tenantId;

    @TableField(typeHandler = MySqlJsonArrayHandler.class)
    private JSONArray sourceIds;

    @TableField(typeHandler = MySqlJsonHandler.class)
    private JSONObject businessUnit;

    @TableField(typeHandler = MySqlJsonHandler.class)
    private JSONObject data;

    /**
     * 0-非紧急，1-紧急
     */
    private Integer emergency;

    /**
     * 紧急度，
     */
    @TableField(exist = false)
    private Integer emergencyValue;

    /*需要变更的子任务Id*/
    @TableField(typeHandler = MySqlJsonArrayHandler.class)
    private JSONArray changedOriginalSubTaskIds;

    /**
     * 动态任务的id,参与项目卡合并计算
     */
    private String compositionId;

    /**
     * 代理 token
     * 优先使用bpm_activity.token，如果没有，则使用此代理token
     */
    private String proxyToken;

    /**
     * 0-未开始、进行中、已暂停
     * 10-关闭—正常結束
     * 20-关闭—終止而結束
     * 30-关闭—撤銷而結束
     * 40-关闭—第三方強制終止而結束
     */
    private Integer subState;

    /**
     * 引擎类型
     */
    private String engineType;

    /**
     * 调用链ID
     */
    private String traceId;

    /**
     * 发送数据足迹的MQ类型。
     * 0- 发送任务消息的 activityId 取 activity.id,默认值
     * 1- 发送任务消息的 activityId 取 bpmActivity.id
     */
    private Integer sdMqType;
}