package com.digiwin.athena.atmc.common.domain;

import com.baomidou.mybatisplus.annotation.TableId;
import com.digiwin.athena.atmc.http.domain.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * bmp_activiti_workitem的附加信息表
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class BpmWorkitemAppendix extends BaseEntity<BpmWorkitemAppendix> {

    /**
     * 主键，bmp_activiti_workitem.id
     */
    @TableId()
    private Long id;

    /**
     * 错误代码：
     *  1001 回复型任务 没有电子邮箱
     *  1002 回复型任务 未注册
     *  1003 回复型任务 无授权
     */
    private Integer errorCode;

    /**
     * 回复型任务的邀请邮箱
     */
    private String email;

    /**
     * 回复型任务的客户名称
     */
    private String supplierName;

}
