package com.digiwin.athena.atmc.common.domain;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.atmc.infrastructure.pojo.po.migration.base.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

/**
 * 通用业务记录
 *
 * @author majianfu
 * @date 2024/9/30
 * @since
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Accessors(chain = true)
@TableName(autoResultMap = true, value = "common_biz_record")
public class CommonBizRecord extends BaseEntity<CommonBizRecord> {
    /**
     * 主键ID，必填
     */
    @TableId
    private Long id;

    /**
     * 租户ID，可选，比如一些全局性约束（也方便后续根据租户清除测试数据）
     */
    private String tenantId;

    /**
     * 业务ID，必填，默认是：活动ID
     */
    private String bizId;

    /**
     * 业务类型，必填，默认是：ACTIVITY
     */
    private String bizType;
}
