package com.digiwin.athena.atmc.common.domain;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class DapResponse<T>{
    private Integer duration;
    private String statusDescription;
    private T response;
    private String uuid;
    private Integer status;
    private String errorMessage;

    public static DapResponse ok(){
        return DapResponse.builder().status(200).build();
    }

    public static <T> DapResponse ok(T data){
        return DapResponse.builder().status(200).response(data).build();
    }

    public static DapResponse failed(String msg){
        return DapResponse.builder().status(500).statusDescription(msg).build();
    }
}
