package com.digiwin.athena.atmc.common.domain;

import com.digiwin.athena.appcore.domain.LanguageMark;
import com.digiwin.athena.atmc.infrastructure.pojo.bo.migration.BacklogPerformerBO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import net.sf.json.JSONObject;

import java.time.LocalDateTime;
import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class TaskPanelActivityDTO {
    private String id;
    @LanguageMark
    private String name;
    @LanguageMark
    private String subName;

    private Integer sequence;
    private Integer state;
    private Integer importance;
    private Boolean exception;
    /**
     * 任务是否异常
     */
    private Boolean hasException;
    private LocalDateTime startTime;
    private LocalDateTime planEndTime;
    private Boolean executeType;
    private Integer totalCount;
    private Integer finishedCount;
    private Boolean actionDefined;
    private String tmCategory;
    private String tmPattern;
    private Boolean tmMilestone;
    private Long activityId;

    private List<BacklogPerformerBO> backlogPerformerBO;

    /**
     * 是否逾期
     */
    private Boolean overdue;

    /**
     * 变更信息
     */
    private JSONObject changedProject;

    /**
     * 实际完成时间
     */
    private LocalDateTime actualEndTime;

    /**
     * 包含逾期完成的任务数量
     */
    private Integer overdueFinishedCount;
}
