package com.digiwin.athena.atmc.common.domain;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.atmc.http.domain.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @author：SYQ
 * @date：2021/12/31
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Accessors(chain = true)
@TableName(autoResultMap = true)
public class TaskWorkitemMessage extends BaseEntity<TaskWorkitemMessage> implements Serializable {
    /**
     * 主键
     **/
    @TableId()
    private Long id;
    /**
     * 卡片id
     **/
    private Long cardId;
    /**
     * 卡片类型
     **/
    private String cardType;
    /**
     * 租户id
     **/
    private String tenantId;
    /**
     * 摘要
     **/
    private String summary;
    /**
     * 历史资讯
     **/
    private String historyMessage;
    /**
     * 搜索项
     **/
    private String searchMessage;
    /**
     *  活动对应摘要 历史咨询 搜索项
     */
    private String activityMessage;

}
