package com.digiwin.athena.atmc.common.domain.approval;

import com.digiwin.athena.appcore.domain.LanguageMark;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.Map;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ApprovalStepDTO {

    private Long id;

    private String bpmActivityId;

    @LanguageMark
    private String bpmActivityName;

    private Integer state;

    private List<ApprovalWorkItemDTO> workitemList;

    //是否转派，表示当前关卡是由别人转派的
    private Boolean isReassign = false;

    //是否退回，表示当前关卡是由别人退回的
    private Boolean isReexecute = false;

    //是否加签，表示当前关卡是加签的
    private Boolean isAddTask = false;

    /**
     * 签核类型，1或签，2会签,3单一签核
     */
    private Integer signType = 1;

    @JsonIgnore
    private String bpmActivityOID;

    /**
     *  KM 附件配置
     */
//    "attachmentConfig": {
//        "dmcAccount": {
//            "password": "KSC",
//             "account": "KSC"
//        },
//        "buckets": "KSC",
//        "readCategory": [
//        "approvalAttachment"
//                ]
//    }
    private Map<String, Object> attachmentConfig;



}
