package com.digiwin.athena.atmc.common.domain.backlog;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author xuhx
 * @date 2024/9/19
 */
@Data
public class SignNoticeDTO implements Serializable {
    private static final long serialVersionUID = 2685991160847255397L;

    /**
     * 签核知会的类型。1-签核前知会；2-签核后知会
     */
    private Integer type;

    /**
     * 要进行知会的待办id
     */
    private Long backlogId;

    /**
     * 要知会的用户的列表
     */
    private List<User> users;

    @Data
    public static class User implements Serializable{
        private static final long serialVersionUID = -5953535629850995771L;
        /**
         * 知会的用户id
         */
        private String userId;

        /**
         * 知会的用户名称
         */
        private String userName;
    }
}
