package com.digiwin.athena.atmc.common.domain.bpm;

import com.digiwin.athena.atmc.http.constant.BpmConstant;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import net.sf.json.JSONObject;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class BpmActivityStepDTO {

    private String activityId;
    private String activityName;

    private LocalDateTime createTime;
    private LocalDateTime closedTime;

    private String tenantId;
    private String tenantSid;

    private String token;
    private String processSerialNumber;
    private String bpmnType;

    private String bpmActivityId;
    private String bpmActivityName;

    private JSONObject bpmSignReason;
    private Integer state;
    private List<BpmStepWorkitemDTO> workitemList;

    private JSONObject data;

    /**
     * bpm中表示step的唯一Key
     * 目前允许为空
     * 对于任务引擎来说：如果该值为空，表示推送的是任务，而不是step
     */
    private String bpmActivityOID;

    /**
     * 签核知会：
     * 签核前知会： signBefore: ["", ""]
     * 签核后知会： signAfter": ["", ""]
     */
    private Map<String, List<String>> informer;

    /**
     * 子状态
     */
    private Integer subState;

    /**
     * 所属任务实例id
     * 租户内唯一
     */
    private String taskUid;

    /**
     * 上个任务实例id
     * 租户内唯一
     */
    private String sourceTaskUid;

    /**
     * 任务输入数据状态描述
     */
    private String inputDataStateDescribe;

    /**
     * 取值 single=单一签核  ；signAnd=会签 ; signOr=或签
     */
    private String bpmnApproveType;

    /**
     * 任务引擎：任务类别。execution，manual，notice，approve
     */
    private String taskType;
    
    /**
     * 流程引擎-获取任务的计划结束时间
     * @return
     */
    public LocalDateTime getPlanEndTime(){

        if(data!=null && data.containsKey(BpmConstant.TASK_ENGINE_PLAN_END_TIME_NAME)
                && !StringUtils.isEmpty(data.getString(BpmConstant.TASK_ENGINE_PLAN_END_TIME_NAME))){
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            return LocalDateTime.parse(data.getString(BpmConstant.TASK_ENGINE_PLAN_END_TIME_NAME), dateTimeFormatter);
        }

        return null;
    }
}
