package com.digiwin.athena.atmc.common.domain.email;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.atmc.http.domain.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Accessors(chain = true)
@TableName(autoResultMap = true, value = "activity_email_management")
public class ActivityEmail extends BaseEntity<ActivityEmail> implements Serializable {
    @TableId()
    private Long emailId;

    @NotBlank
    private String tenantId;

    /**
     * 归属哪个应用
     */
    private String appCode;

    /**
     * 邮件名称
     */
    private String emailName;

    /**
     * 邮件描述
     */
    private String description;

    /**
     * 邮件类型
     * 邮件类型-枚举型，对应
     */
    private Integer type;

    /**
     * 邮件类型
     * 2-已失效，1-使用中；0-已停用
     * 鼎捷云删除模板的时候，传1，鼎捷云删除模板的时候，传2
     */
    private Integer state;

    /**
     * 邮件模板创建时间
     */
//    private LocalDateTime createTime;

    /**
     * 邮件模板更新人
     */
    private String uptateBy;

    /**
     * 邮件模板预览id
     * 对应的是中间件api---/api/emc/v1/notices/settings的入参 事件id
     */
    private String previewId;

    /**
     * 该模板是配的
     */
    @TableField(exist = false)
    List<ActivityEmailRelation> activityList;

    /**
     * 接受该邮件模板的人员
     */
    @TableField(exist = false)
    List<ActivityEmailStaff> receiveStaff;

    /**
     * 收件人
     */
    @TableField(exist = false)
    String contacts;

    /**
     * 邮件模板语言别
     *
     */
    private String langName;

}
