package com.digiwin.athena.atmc.common.domain.eventbus;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.enentbus.EventBase;
import com.digiwin.athena.atmc.infrastructure.pojo.po.migration.PtmBacklog;

/**
 * 用于同步本地和ptm的backlog事件
 */
public class SyncBackLogEventDTO extends EventBase<PtmBacklog> {

    AuthoredUser authoredUser;

    public SyncBackLogEventDTO(PtmBacklog backlog, AuthoredUser authoredUser) {
        super(OperatorType.SYNC.name(), backlog);
        this.authoredUser = authoredUser;
    }

    @Override
    public AuthoredUser getAuthoredUser() {
        return authoredUser;
    }
}
