package com.digiwin.athena.atmc.common.domain.eventbus;


import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.sf.json.JSONObject;

/**
 * @Author wuzq
 * @Date 2023/5/25 13:26
 * @Description: 项目卡的数据一致性，生成BK消息
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Accessors(chain = true)
public class TaskUniformityMessage {
    /**
     * task.id
     * ptmProject.id
     * ptm 项目卡id
     */
    private Long id;
    /**
     * task.tenantId
     * 租户id
     */
    private String tenantId;
    /**
     * task.tmTaskId
     * ptmProject.projectDefCode
     * kg项目定义code
     */
    private String tmTaskId;
    /**
     * task.state
     * ptmProject.state
     * ptm 项目状态
     */
    private Integer state;
    /**
     * ptm 来源单号
     */
    private String sourceIds;
    /**
     * task.businessUnit
     * ptmProject.businessUnit
     * ptm 项目业务单元
     */
    private JSONObject businessUnit;
    /**
     * bpmProcess.data
     * ptmTask.data
     * 项目备注
     */
    private JSONObject data;

    private Boolean closed;

    private String type;
}