package com.digiwin.athena.atmc.common.domain.ptm.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import net.sf.json.JSONObject;

import java.time.LocalDateTime;
import java.util.List;

/**
 * PTM 待办 消息类型
 *
 * @author zhujg
 * @date 2022-01-20
 */
@Data
public class PtmBacklogMessageDTO extends PtmMqMessageDTO {

    private MqData data;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class MqData {
        /**
         * 待办
         */
        private Backlog backlog;

        /**
         * 导致任务卡变更的原因，转派：REASSIGN  交接：HANDOVER
         */
        private String changeType;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class Backlog {

        private Long backlogId;
        /**
         * 待办的目标租户
         */
        private String tenantId;
        private Long projectCardId;
        private Long projectId;

        /**
         * 相当于 bpmActivity.Id
         */
        private Long taskId;

        /**
         * 相当于 bpmActivityStep.id
         */
        private Long activityId;

        /**
         * 相当于 bpmActivityWorkitem.id
         */
        private Long workItemId;
        private String performerId;
        private String performerName;
        private Boolean closed;
        private LocalDateTime planEndTime;

        private String taskDefCode;
        private String taskDefName;

        private String taskName;

        private LocalDateTime createTime;
        private LocalDateTime closedTime;
        private LocalDateTime startTime;

        /**
         * 是否是合并的工作项
         */
        private Boolean merge;

        /**
         * 处理者类型0:默认;1:辅助执行者;2:跨租户
         */
        private Integer type;

        /**
         * 来源类型
         */
        private String sourceType;

        /**
         * 通道
         */
        private List<String> channel;

        /**
         * 任务卡是否隐藏
         */
        private Boolean hidden;


        /**
         * 语系 zh_CN:简体中文 zh_TW:繁体中文 en_US:英文
         */
        private String locale;

        /**
         * 是否上传附件 true：是 false：否
         */
        private Boolean uploadAttachmentFlag = Boolean.FALSE;

        /**
         * excel展示字段设定 包括列头，顺序，展示名称
         *
         * [{
         *   "field": "age",
         *   "sequence": 0,
         *   "fieldName": "年龄",
         * 	 "language":{
         *       "fieldName":{
         *          "zh_TW" : "年齡",
         *          "en_US" : "age",
         *          "zh_CN" : "年龄"
         *       }
         *    }
         * }]
         *
         */
        private List<excelSettingDTO> excelStrucSetting;

        /**
         * 任务源数据
         *
         * [{
         *     "age": 18,
         *     "name":  "jack"
         * }]
         *
         */
        private List<JSONObject> excelSourceData;

    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class excelSettingDTO {
        /**
         * 字段key
         */
        private String field;

        /**
         * 字段顺序
         */
        private Integer sequence;

        /**
         * 默认字段名称
         */
        private String fieldName;

        /**
         * 语系映射
         */
        private languageDTO language;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class languageDTO {

        /**
         * 各语系映射的字段名称
         */
        private JSONObject fieldName;
    }

}
