package com.digiwin.athena.atmc.common.domain.ptm.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * PTM MQ 消息
 * @author zhujg
 * @date 2022-01-20
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class PtmMqMessageDTO {

    /**
     * 消息ID
     */
    private String messageId;

    /**
     * 消息对象类别，projectCard-项目卡(主项目)，project-项目(子项目)、task-任务卡
     */
    private PtmMqType type;

    /**
     * 消息类型。
     */
    private PtmMqOperation operation;

    /**
     * user信息
     */
    private PtmUserDTO user;

}
