package com.digiwin.athena.atmc.common.domain.task;

import com.digiwin.athena.appcore.domain.LanguageMark;
import com.digiwin.athena.atmc.http.domain.Task;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper=true)
@ToString
public class TaskExtendDTO extends Task {

    /**
     *
     */
    private static final long serialVersionUID = -192092611926893830L;

    private Integer subTaskCount;

    /**
     * 提交唯一键
     */
    private Integer submitId;

    /**
     * 包含已完成的子任务数量
     */
    private Integer subTaskFinishedCount;

    private Integer mainTaskEmergencyCount;

    private Integer importanceCount;

    /**
     * start_changed_sub_task_id 字段的和
     * 不为0表示有变更
     */
    private Long changedSum;


//    private Long mainTaskId;


    /**
     * 节点名称
     */
    @LanguageMark
    private String activityName;

    /**
     * 是否自动
     */
    private String tmExecuteType;

    /**
     * 总数
     */
    private Integer total;
    /**
     * 逾期时间
     */
    private Integer overdue;

    /**
     * 正在进行中的不重复的任务(关卡)数量
     */
    private Integer activityCount;

    /**
     * 最后修改时间
     */
    private LocalDateTime lastModifyDate;

    /**
     * key：运营单位名称， value：工单列表
     */
    Collection<TaskSourceDTO> sources;

    private List sourceOperations;

    /**
     * 签章文本，显示例如"已转派"等字样
     */
    private String sealText;

    /**
     * 最新、未读的子项目来源单号
     */
    private String lastNewSourceIds;

    private Boolean exception;

    private Boolean isOwner;

    private String summary;
    private String historyMessage;
    private String searchMessage;

    /**
     * 项目是否已结束
     */
    private boolean finished;

    /**
     * 异常任务数量
     */
    private Integer activityExceptionCount;
}
