package com.digiwin.athena.atmc.common.enums;


import com.baomidou.mybatisplus.core.enums.IEnum;
import org.apache.commons.lang.StringUtils;

/**
 * 错误类型
 */
public enum WorkitemAppendixType implements IEnum<Integer> {

    /**
     * 0-Normal-正常
     */
    Normal("Normal", 0),

    /**
     * 1001-NoEmail-回复型任务 没有电子邮箱
     */
    NoEmail("NoEmail", 1001),

    /**
     * 1002-NoRegister-回复型任务 未注册云账号
     */
    NoRegister("NoRegister", 1002),

    /**
     * 1003-NoPermission-回复型任务 未授权
     */
    NoPermission("NoPermission", 1003),

    /**
     * 1004-PermissionFull-回复型任务 授权已满
     */
    PermissionFull("PermissionFull", 1004),

    /**
     * 1005-NoTenant-回复型任务 未加入指定租户
     */
    NoTenant("NoTenant", 1005),

    /**
     * 1006-Invited-回复型任务 已完成注册申请
     */
    Invited("Invited", 1006),

    /**
     * 1007-Inviting-回复型任务 提出邀请中
     */
    Inviting("Inviting", 1007),

    /**
     * 1008-ReSend-回复型任务 任务重发成功
     */
    ReSend("ReSend", 1008),

    /**
     * 1009-NoPhone-回复型任务 没有手机号
     */
    NoPhone("NoPhone", 1009);


    private String name;
    private Integer value;

    WorkitemAppendixType(String name,Integer value){
        this.name = name;
        this.value = value;
    }

    public String getName() { return name;}

    @Override
    public Integer getValue() {
        return value;
    }

    public static WorkitemAppendixType parse(String signType){
        if(StringUtils.equalsIgnoreCase(signType, NoEmail.getName())){
            return NoEmail;
        }else if(StringUtils.equalsIgnoreCase(signType, NoRegister.getName())){
            return NoRegister;
        }else if(StringUtils.equalsIgnoreCase(signType, NoPermission.getName())){
            return NoPermission;
        }else if(StringUtils.equalsIgnoreCase(signType, PermissionFull.getName())){
            return PermissionFull;
        }else{
            return NoPermission;
        }
    }

}
