//package com.digiwin.athena.atmc.common.handler;
//
//import com.digiwin.athena.appcore.auth.AppAuthContext;
//import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
//import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
//import com.digiwin.athena.appcore.util.JsonUtils;
//import com.digiwin.athena.atmc.common.bk.parser.IParser;
//import com.digiwin.athena.atmc.common.bk.parser.bo.ParserBo;
//import com.digiwin.athena.atmc.common.bk.parser.event.TaskEvent;
//import com.digiwin.athena.atmc.common.bk.service.BkTaskActivityService;
//import com.digiwin.athena.atmc.common.bk.service.BusinessKeyService;
//import com.digiwin.athena.atmc.common.domain.eventbus.ActivityUniformityMqDTO;
//import com.digiwin.athena.atmc.common.domain.eventbus.DataUniformityMqDTO;
//import com.digiwin.athena.atmc.common.enums.EventTypeEnum;
//import com.digiwin.athena.atmc.common.event.ActivityUniformityEvent;
//import com.digiwin.athena.atmc.common.event.model.ActivityUniformityModel;
//import com.digiwin.athena.atmc.common.handler.base.AtmcBaseMessageHandler;
//import lombok.extern.slf4j.Slf4j;
//import net.sf.json.JSONArray;
//import net.sf.json.JSONObject;
//import org.springframework.amqp.rabbit.core.RabbitTemplate;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.util.CollectionUtils;
//
//import java.util.ArrayList;
//import java.util.List;
//import java.util.Map;
//
//@Slf4j
//public class ActivityUniformityHandler implements AtmcBaseMessageHandler<ActivityUniformityEvent> {
//    @Autowired
//    private RabbitTemplate rabbitTemplate;
//
//    @Autowired
//    private BusinessKeyService businessKeyService;
//
//    @Autowired
//    private IParser iParser;
//
//    @Autowired
//    private BkTaskActivityService bkTaskActivityService;
//
//    //消息队列名称
//    private final String TASK_QUEUE = "DC_TASK_QUEUE";
//    //交换机
//    private final String TASK_EXCHANGE = "DC_TASK_EXCHANGE";
//
//    private final String TASK_ROUTER_KEY = "DC_TASK_ROUTER_KEY";
//
//    @Override
//    public boolean support(EventTypeEnum eventTypeEnum) {
//        return EventTypeEnum.TASK_CONSISTENCY_BK.equals(eventTypeEnum);
//    }
//
//    public void process(ActivityUniformityEvent event) {
//        try {
//            processEvent(event);
//        } catch (Exception ex) {
//            log.error(ex.getMessage(), ex);
//        } finally {
//            AppAuthContextHolder.clearContext();
//        }
//    }
//
//    private void processEvent(ActivityUniformityEvent event) {
//        //获取event里的数据
//        ActivityUniformityModel activityUniformityModel = event.getContent();
//        //token
//        AuthoredUser authoredUser = event.getAuthoredUser();
//        //将token放入线程内
//        AppAuthContext appAuthContext = new AppAuthContext();
//        appAuthContext.setAuthoredUser(authoredUser);
//        AppAuthContextHolder.setContext(appAuthContext);
//        //向mq内推送消息
//        ActivityUniformityMqDTO activityDataUniformityMqDTO = senMqToSd(activityUniformityModel);
//        //数据一致性定义的bk值集合
//        if (!activityUniformityModel.getClosed()) {
//            dealDataUniformity(activityUniformityModel, authoredUser, activityDataUniformityMqDTO);
//        }
//    }
//
//    /**
//     * 向mq内推消息
//     *
//     * @Author：SYQ
//     * @Date：2022/5/27 14:38
//     */
//    private ActivityUniformityMqDTO senMqToSd(ActivityUniformityModel activityUniformityMessage) {
//        DataUniformityMqDTO dataUniformityMqDTO = new DataUniformityMqDTO();
//        dataUniformityMqDTO.setBusinessUnit(activityUniformityMessage.getBusinessUnit());
//        dataUniformityMqDTO.setProcessVar(activityUniformityMessage.getData());
//
//        ActivityUniformityMqDTO activityDataUniformityMqDTO = ActivityUniformityMqDTO.builder().tenantId(activityUniformityMessage.getTenantId()).state(activityUniformityMessage.getState()).activityId(activityUniformityMessage.getActivityId().toString()).activityTemplateId(activityUniformityMessage.getTmActivityId()).subTaskTemplateId(activityUniformityMessage.getTmTaskId()).subTaskId(activityUniformityMessage.getSubTaskId().toString()).type("activity").messageData(dataUniformityMqDTO).build();
//
//        //将任务数据推入MQ内
//        rabbitTemplate.convertAndSend(TASK_EXCHANGE, TASK_ROUTER_KEY, JsonUtils.objectToString(activityDataUniformityMqDTO));
//        log.info("任务消息队列：{}", JsonUtils.objectToString(activityDataUniformityMqDTO));
//        return activityDataUniformityMqDTO;
//    }
//
//    /**
//     * 数据一致性
//     *
//     * @Author：SYQ
//     * @Date：2022/1/6 10:26
//     */
//    private List<JSONObject> dealDataUniformity(ActivityUniformityModel activityUniformityMessage, AuthoredUser authoredUser, ActivityUniformityMqDTO activityDataUniformityMqDTO) {
//        /*记录BK、项目卡的关联关系 start*/
//        //是否存在数据一致性的bk，默认不存在
//        boolean hasDataUniformityBk = false;
//        //数据一致性的bk
//        List<JSONObject> bkList = new ArrayList<>();
//        try {
//            //获取businessKey
//            TaskEvent taskEvent = new TaskEvent(JSONObject.fromObject(activityDataUniformityMqDTO));
//            List<ParserBo> parserBoList = iParser.parse(taskEvent, authoredUser);
//            //将businessKey转为字符串
//            if (!CollectionUtils.isEmpty(parserBoList)) {
//                //存在数据一致性的bk
//                hasDataUniformityBk = true;
//                //获取bk内容
//                for (ParserBo parserBo : parserBoList) {
//                    bkList.add(parserBo.getBkInfo());
//                }
//                //记录BusinessKey和项目卡/任务卡的关联关系
//                businessKeyService.insertBkTaskActivity(parserBoList, activityUniformityMessage.getWorkitemId(), activityUniformityMessage.getTenantId(), "workitem");
//            }
//        } catch (Exception e) {
//            log.error("【获取数据一致性bk失败】：{}", e.getMessage());
//        }
//
//        //不存在数据一致性bk时，获取TM中定义的bk
//        if (!hasDataUniformityBk) {
//            //themMap中定义的bk值集合
//            Map<String, Object> bkMap = bkTaskActivityService.getTmBusinessKeyNew(activityUniformityMessage.getTmTaskId(), activityUniformityMessage.getTmActivityId(), activityUniformityMessage.getBpmData());
//            //复杂结构的bk
//            List<JSONObject> bkValueList = new ArrayList<>();
//            if (bkMap.containsKey("complex")) {
//                bkValueList = JSONArray.fromObject(bkMap.get("complex"));
//            }
//            //简单结构的bk
//            List<Object> bkObjectValueList = new ArrayList<>();
//            if (bkMap.containsKey("simple")) {
//                bkObjectValueList = JSONArray.fromObject(bkMap.get("simple"));
//            }
//            //记录BusinessKey和项目卡/任务卡的关联关系
//            bkTaskActivityService.insertOriBk(bkValueList, bkObjectValueList, activityUniformityMessage.getWorkitemId(), activityUniformityMessage.getTenantId(), "workitem");
//        }
//
//        /*记录BK、项目卡的关联关系 end*/
//        return bkList;
//    }
//}
