//package com.digiwin.athena.atmc.common.handler;
//
//import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
//import com.digiwin.athena.appcore.util.JsonUtils;
//import com.digiwin.athena.atmc.common.bk.parser.IParser;
//import com.digiwin.athena.atmc.common.bk.parser.bo.ParserBo;
//import com.digiwin.athena.atmc.common.bk.parser.event.TaskEvent;
//import com.digiwin.athena.atmc.common.bk.service.BusinessKeyService;
//import com.digiwin.athena.atmc.http.constant.ErrorCodeEnum;
//import com.digiwin.athena.atmc.common.event.TaskUniformityEvent;
//import com.digiwin.athena.atmc.common.domain.eventbus.DataUniformityMqDTO;
//import com.digiwin.athena.atmc.common.domain.eventbus.TaskUniformityMqDTO;
//import com.digiwin.athena.atmc.common.enums.EventTypeEnum;
//import com.digiwin.athena.atmc.common.event.model.TaskUniformityModel;
//import com.digiwin.athena.atmc.common.handler.base.AtmcBaseMessageHandler;
//import lombok.extern.slf4j.Slf4j;
//import net.sf.json.JSONObject;
//import org.apache.commons.collections.CollectionUtils;
//import org.springframework.amqp.rabbit.core.RabbitTemplate;
//import org.springframework.beans.factory.annotation.Autowired;
//
//import java.util.ArrayList;
//import java.util.List;
//
//@Slf4j
//public class TaskUniformityHandler implements AtmcBaseMessageHandler<TaskUniformityEvent> {
//    @Autowired
//    private RabbitTemplate rabbitTemplate;
//
//    @Autowired
//    private BusinessKeyService businessKeyService;
//
//    @Autowired
//    private IParser iParser;
//
//    //消息队列名称
//    private final String TASK_QUEUE = "DC_TASK_QUEUE";
//    //交换机
//    private final String TASK_EXCHANGE = "DC_TASK_EXCHANGE";
//
//    private final String TASK_ROUTER_KEY = "DC_TASK_ROUTER_KEY";
//
//    @Override
//    public boolean support(EventTypeEnum eventTypeEnum) {
//        return EventTypeEnum.PROJECT_CONSISTENCY_BK.equals(eventTypeEnum);
//    }
//
//    public void process(TaskUniformityEvent event) {
//        try {
//            processEvent(event);
//        } catch (Exception ex) {
//            log.error(ex.getMessage(), ex);
//        }
//    }
//
//    private void processEvent(TaskUniformityEvent event) {
//        //获取event里的数据
//        TaskUniformityModel taskUniformityModel = event.getContent();
//        //项目数据
////        Task task = taskUniformityEventDTO.getTask();
//        //流程数据
////        BpmProcess bpmProcess = taskUniformityEventDTO.getBpmProcess();
//        //token
//        AuthoredUser authoredUser = event.getAuthoredUser();
//
//        /*整理推入MQ的消息内容 start*/
//        TaskUniformityMqDTO taskDataUniformityMqDTO = new TaskUniformityMqDTO();
//        taskDataUniformityMqDTO.setTenantId(taskUniformityModel.getTenantId());
//        taskDataUniformityMqDTO.setState(taskUniformityModel.getState());
//        taskDataUniformityMqDTO.setSubTaskTemplateId(taskUniformityModel.getTmTaskId());
//        taskDataUniformityMqDTO.setSubTaskId(taskUniformityModel.getId().toString());
//        taskDataUniformityMqDTO.setType("task");
//        taskDataUniformityMqDTO.setSourceIds(taskUniformityModel.getSourceIds());
//
//        DataUniformityMqDTO dataUniformityMqDTO = new DataUniformityMqDTO();
//        dataUniformityMqDTO.setBusinessUnit(taskUniformityModel.getBusinessUnit());
//        dataUniformityMqDTO.setProcessVar(taskUniformityModel.getData());
//        taskDataUniformityMqDTO.setMessageData(dataUniformityMqDTO);
//
//        //将项目数据推入MQ内
//        rabbitTemplate.convertAndSend(TASK_EXCHANGE, TASK_ROUTER_KEY, JsonUtils.objectToString(taskDataUniformityMqDTO));
//        log.info("项目消息队列：{}", JsonUtils.objectToString(taskDataUniformityMqDTO));
//        /*整理推入MQ的消息内容 end*/
//
//        /*记录BK、项目卡的关联关系 start*/
//        try {
//            //获取businessKey
//            TaskEvent taskEvent = new TaskEvent(JSONObject.fromObject(taskDataUniformityMqDTO));
//            List<ParserBo> parserBoList = iParser.parse(taskEvent, authoredUser);
//            //将businessKey转为字符串
//            List<JSONObject> bkList = new ArrayList<>();
//            if (CollectionUtils.isNotEmpty(parserBoList)) {
//                for (ParserBo parserBo : parserBoList) {
//                    bkList.add(parserBo.getBkInfo());
//                }
//                //记录BusinessKey和项目卡/任务卡的关联关系
//                businessKeyService.insertBkTaskActivity(parserBoList, taskUniformityModel.getId(), taskUniformityModel.getTenantId(), "task");
//            }
//        } catch (Exception e) {
//            throw ErrorCodeEnum.TASK_UNIFORMITY.getBusinessException();
//        }
//        /*记录BK、项目卡的关联关系 end*/
//    }
//}
